@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RegistryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Details of the Registry
 * @property discoveryUrl Discovery URL for the Registry
 * @property intellectualPropertyPublisher IntellectualPropertyPublisher for the registry
 * @property managedResourceGroup ResourceId of the managed RG if the registry has system created resources
 * @property mlFlowRegistryUri MLFlow Registry URI for the Registry
 * @property privateEndpointConnections Private endpoint connections info used for pending connections in private link portal
 * @property publicNetworkAccess Is the Registry accessible from the internet?
 * Possible values: "Enabled" or "Disabled"
 * @property regionDetails Details of each region the registry is in
 */
public data class RegistryArgs(
    public val discoveryUrl: Output<String>? = null,
    public val intellectualPropertyPublisher: Output<String>? = null,
    public val managedResourceGroup: Output<ArmResourceIdArgs>? = null,
    public val mlFlowRegistryUri: Output<String>? = null,
    public val privateEndpointConnections: Output<List<RegistryPrivateEndpointConnectionArgs>>? =
        null,
    public val publicNetworkAccess: Output<String>? = null,
    public val regionDetails: Output<List<RegistryRegionArmDetailsArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.RegistryArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RegistryArgs.builder()
            .discoveryUrl(discoveryUrl?.applyValue({ args0 -> args0 }))
            .intellectualPropertyPublisher(intellectualPropertyPublisher?.applyValue({ args0 -> args0 }))
            .managedResourceGroup(
                managedResourceGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mlFlowRegistryUri(mlFlowRegistryUri?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .regionDetails(
                regionDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RegistryArgs].
 */
@PulumiTagMarker
public class RegistryArgsBuilder internal constructor() {
    private var discoveryUrl: Output<String>? = null

    private var intellectualPropertyPublisher: Output<String>? = null

    private var managedResourceGroup: Output<ArmResourceIdArgs>? = null

    private var mlFlowRegistryUri: Output<String>? = null

    private var privateEndpointConnections: Output<List<RegistryPrivateEndpointConnectionArgs>>? =
        null

    private var publicNetworkAccess: Output<String>? = null

    private var regionDetails: Output<List<RegistryRegionArmDetailsArgs>>? = null

    /**
     * @param value Discovery URL for the Registry
     */
    @JvmName("pyaqoctrmrfijadv")
    public suspend fun discoveryUrl(`value`: Output<String>) {
        this.discoveryUrl = value
    }

    /**
     * @param value IntellectualPropertyPublisher for the registry
     */
    @JvmName("fjcxvwcbpeybvmtu")
    public suspend fun intellectualPropertyPublisher(`value`: Output<String>) {
        this.intellectualPropertyPublisher = value
    }

    /**
     * @param value ResourceId of the managed RG if the registry has system created resources
     */
    @JvmName("vckjnyniugtngifj")
    public suspend fun managedResourceGroup(`value`: Output<ArmResourceIdArgs>) {
        this.managedResourceGroup = value
    }

    /**
     * @param value MLFlow Registry URI for the Registry
     */
    @JvmName("ocwnahrublrhqalk")
    public suspend fun mlFlowRegistryUri(`value`: Output<String>) {
        this.mlFlowRegistryUri = value
    }

    /**
     * @param value Private endpoint connections info used for pending connections in private link portal
     */
    @JvmName("txbfssldosquusag")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<RegistryPrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("amhyrnowsqtkmfqu")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<RegistryPrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values Private endpoint connections info used for pending connections in private link portal
     */
    @JvmName("mfcwgxbwwstoajax")
    public suspend
    fun privateEndpointConnections(values: List<Output<RegistryPrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value Is the Registry accessible from the internet?
     * Possible values: "Enabled" or "Disabled"
     */
    @JvmName("xwrnbykckmvxamep")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Details of each region the registry is in
     */
    @JvmName("galcsxghalewuuus")
    public suspend fun regionDetails(`value`: Output<List<RegistryRegionArmDetailsArgs>>) {
        this.regionDetails = value
    }

    @JvmName("lfpopxcqmtsjiuqf")
    public suspend fun regionDetails(vararg values: Output<RegistryRegionArmDetailsArgs>) {
        this.regionDetails = Output.all(values.asList())
    }

    /**
     * @param values Details of each region the registry is in
     */
    @JvmName("unewymcprggbhpcj")
    public suspend fun regionDetails(values: List<Output<RegistryRegionArmDetailsArgs>>) {
        this.regionDetails = Output.all(values)
    }

    /**
     * @param value Discovery URL for the Registry
     */
    @JvmName("rvgcnjthysuebars")
    public suspend fun discoveryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveryUrl = mapped
    }

    /**
     * @param value IntellectualPropertyPublisher for the registry
     */
    @JvmName("qqhvrrdinvtwmbwx")
    public suspend fun intellectualPropertyPublisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intellectualPropertyPublisher = mapped
    }

    /**
     * @param value ResourceId of the managed RG if the registry has system created resources
     */
    @JvmName("poysemnvhrexmqhm")
    public suspend fun managedResourceGroup(`value`: ArmResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroup = mapped
    }

    /**
     * @param argument ResourceId of the managed RG if the registry has system created resources
     */
    @JvmName("pgvnlnwperfdhdtd")
    public suspend fun managedResourceGroup(argument: suspend ArmResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ArmResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroup = mapped
    }

    /**
     * @param value MLFlow Registry URI for the Registry
     */
    @JvmName("rgfdopofdohxyrdy")
    public suspend fun mlFlowRegistryUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mlFlowRegistryUri = mapped
    }

    /**
     * @param value Private endpoint connections info used for pending connections in private link portal
     */
    @JvmName("bixngyjkjfcsetky")
    public suspend
    fun privateEndpointConnections(`value`: List<RegistryPrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections info used for pending connections in private link portal
     */
    @JvmName("pymjviwwghkcilep")
    public suspend
    fun privateEndpointConnections(argument: List<suspend RegistryPrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegistryPrivateEndpointConnectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections info used for pending connections in private link portal
     */
    @JvmName("scatatvdwfowunsa")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend RegistryPrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RegistryPrivateEndpointConnectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections info used for pending connections in private link portal
     */
    @JvmName("fbwakcftvvgxrfty")
    public suspend
    fun privateEndpointConnections(argument: suspend RegistryPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RegistryPrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values Private endpoint connections info used for pending connections in private link portal
     */
    @JvmName("tsxatutwxobqbowd")
    public suspend fun privateEndpointConnections(
        vararg
        values: RegistryPrivateEndpointConnectionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value Is the Registry accessible from the internet?
     * Possible values: "Enabled" or "Disabled"
     */
    @JvmName("xlsoktntatglbfcy")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Details of each region the registry is in
     */
    @JvmName("ftvahtanxyncypei")
    public suspend fun regionDetails(`value`: List<RegistryRegionArmDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionDetails = mapped
    }

    /**
     * @param argument Details of each region the registry is in
     */
    @JvmName("jchcwikbdvlursre")
    public suspend
    fun regionDetails(argument: List<suspend RegistryRegionArmDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegistryRegionArmDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regionDetails = mapped
    }

    /**
     * @param argument Details of each region the registry is in
     */
    @JvmName("vijdrjgboiaasdjq")
    public suspend fun regionDetails(
        vararg
        argument: suspend RegistryRegionArmDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RegistryRegionArmDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regionDetails = mapped
    }

    /**
     * @param argument Details of each region the registry is in
     */
    @JvmName("nuktvwmfisdxqxhl")
    public suspend
    fun regionDetails(argument: suspend RegistryRegionArmDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RegistryRegionArmDetailsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.regionDetails = mapped
    }

    /**
     * @param values Details of each region the registry is in
     */
    @JvmName("lalssiksyakwbvtd")
    public suspend fun regionDetails(vararg values: RegistryRegionArmDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionDetails = mapped
    }

    internal fun build(): RegistryArgs = RegistryArgs(
        discoveryUrl = discoveryUrl,
        intellectualPropertyPublisher = intellectualPropertyPublisher,
        managedResourceGroup = managedResourceGroup,
        mlFlowRegistryUri = mlFlowRegistryUri,
        privateEndpointConnections = privateEndpointConnections,
        publicNetworkAccess = publicNetworkAccess,
        regionDetails = regionDetails,
    )
}
