@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ScriptReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Script reference
 * @property scriptArguments Optional command line arguments passed to the script to run.
 * @property scriptData The location of scripts in the mounted volume.
 * @property scriptSource The storage source of the script: workspace.
 * @property timeout Optional time period passed to timeout command.
 */
public data class ScriptReferenceArgs(
    public val scriptArguments: Output<String>? = null,
    public val scriptData: Output<String>? = null,
    public val scriptSource: Output<String>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ScriptReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ScriptReferenceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ScriptReferenceArgs.builder()
            .scriptArguments(scriptArguments?.applyValue({ args0 -> args0 }))
            .scriptData(scriptData?.applyValue({ args0 -> args0 }))
            .scriptSource(scriptSource?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptReferenceArgs].
 */
@PulumiTagMarker
public class ScriptReferenceArgsBuilder internal constructor() {
    private var scriptArguments: Output<String>? = null

    private var scriptData: Output<String>? = null

    private var scriptSource: Output<String>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value Optional command line arguments passed to the script to run.
     */
    @JvmName("tnfddcjjtbrwmfgb")
    public suspend fun scriptArguments(`value`: Output<String>) {
        this.scriptArguments = value
    }

    /**
     * @param value The location of scripts in the mounted volume.
     */
    @JvmName("vqoohuhdcurdipdk")
    public suspend fun scriptData(`value`: Output<String>) {
        this.scriptData = value
    }

    /**
     * @param value The storage source of the script: workspace.
     */
    @JvmName("jqqowyhjkangmhom")
    public suspend fun scriptSource(`value`: Output<String>) {
        this.scriptSource = value
    }

    /**
     * @param value Optional time period passed to timeout command.
     */
    @JvmName("qblrrxtugicmvwds")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value Optional command line arguments passed to the script to run.
     */
    @JvmName("viaiccsykoeejaca")
    public suspend fun scriptArguments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptArguments = mapped
    }

    /**
     * @param value The location of scripts in the mounted volume.
     */
    @JvmName("oiwmmspscgfsiqdp")
    public suspend fun scriptData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptData = mapped
    }

    /**
     * @param value The storage source of the script: workspace.
     */
    @JvmName("vbbxjnvyretalqhw")
    public suspend fun scriptSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptSource = mapped
    }

    /**
     * @param value Optional time period passed to timeout command.
     */
    @JvmName("imxtupdawcvbxqfm")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ScriptReferenceArgs = ScriptReferenceArgs(
        scriptArguments = scriptArguments,
        scriptData = scriptData,
        scriptSource = scriptSource,
        timeout = timeout,
    )
}
