@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SystemCreatedStorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allowBlobPublicAccess Public blob access allowed
 * @property armResourceId This is populated once the storage account is created.
 * @property storageAccountHnsEnabled HNS enabled for storage account
 * @property storageAccountName Name of the storage account
 * @property storageAccountType Allowed values:
 * "Standard_LRS",
 * "Standard_GRS",
 * "Standard_RAGRS",
 * "Standard_ZRS",
 * "Standard_GZRS",
 * "Standard_RAGZRS",
 * "Premium_LRS",
 * "Premium_ZRS"
 */
public data class SystemCreatedStorageAccountArgs(
    public val allowBlobPublicAccess: Output<Boolean>? = null,
    public val armResourceId: Output<ArmResourceIdArgs>? = null,
    public val storageAccountHnsEnabled: Output<Boolean>? = null,
    public val storageAccountName: Output<String>? = null,
    public val storageAccountType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SystemCreatedStorageAccountArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.SystemCreatedStorageAccountArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SystemCreatedStorageAccountArgs.builder()
            .allowBlobPublicAccess(allowBlobPublicAccess?.applyValue({ args0 -> args0 }))
            .armResourceId(armResourceId?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountHnsEnabled(storageAccountHnsEnabled?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .storageAccountType(storageAccountType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SystemCreatedStorageAccountArgs].
 */
@PulumiTagMarker
public class SystemCreatedStorageAccountArgsBuilder internal constructor() {
    private var allowBlobPublicAccess: Output<Boolean>? = null

    private var armResourceId: Output<ArmResourceIdArgs>? = null

    private var storageAccountHnsEnabled: Output<Boolean>? = null

    private var storageAccountName: Output<String>? = null

    private var storageAccountType: Output<String>? = null

    /**
     * @param value Public blob access allowed
     */
    @JvmName("phwsrlmfkrhopcsi")
    public suspend fun allowBlobPublicAccess(`value`: Output<Boolean>) {
        this.allowBlobPublicAccess = value
    }

    /**
     * @param value This is populated once the storage account is created.
     */
    @JvmName("nevnxqalktvcfnbf")
    public suspend fun armResourceId(`value`: Output<ArmResourceIdArgs>) {
        this.armResourceId = value
    }

    /**
     * @param value HNS enabled for storage account
     */
    @JvmName("hypircsemlfenwpc")
    public suspend fun storageAccountHnsEnabled(`value`: Output<Boolean>) {
        this.storageAccountHnsEnabled = value
    }

    /**
     * @param value Name of the storage account
     */
    @JvmName("pfmfbfgyopupxodk")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Allowed values:
     * "Standard_LRS",
     * "Standard_GRS",
     * "Standard_RAGRS",
     * "Standard_ZRS",
     * "Standard_GZRS",
     * "Standard_RAGZRS",
     * "Premium_LRS",
     * "Premium_ZRS"
     */
    @JvmName("arrbnaixvuedlkyk")
    public suspend fun storageAccountType(`value`: Output<String>) {
        this.storageAccountType = value
    }

    /**
     * @param value Public blob access allowed
     */
    @JvmName("xtglexwuiaavomdj")
    public suspend fun allowBlobPublicAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowBlobPublicAccess = mapped
    }

    /**
     * @param value This is populated once the storage account is created.
     */
    @JvmName("vidacislkrdauhnh")
    public suspend fun armResourceId(`value`: ArmResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.armResourceId = mapped
    }

    /**
     * @param argument This is populated once the storage account is created.
     */
    @JvmName("gwjsootgfqirsxsy")
    public suspend fun armResourceId(argument: suspend ArmResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ArmResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.armResourceId = mapped
    }

    /**
     * @param value HNS enabled for storage account
     */
    @JvmName("afcyflnwmbcuyrmj")
    public suspend fun storageAccountHnsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountHnsEnabled = mapped
    }

    /**
     * @param value Name of the storage account
     */
    @JvmName("xtqglqssvehxlbyp")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Allowed values:
     * "Standard_LRS",
     * "Standard_GRS",
     * "Standard_RAGRS",
     * "Standard_ZRS",
     * "Standard_GZRS",
     * "Standard_RAGZRS",
     * "Premium_LRS",
     * "Premium_ZRS"
     */
    @JvmName("tetmrpfijcxpmytk")
    public suspend fun storageAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    internal fun build(): SystemCreatedStorageAccountArgs = SystemCreatedStorageAccountArgs(
        allowBlobPublicAccess = allowBlobPublicAccess,
        armResourceId = armResourceId,
        storageAccountHnsEnabled = storageAccountHnsEnabled,
        storageAccountName = storageAccountName,
        storageAccountType = storageAccountType,
    )
}
