@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.TextNerArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LogVerbosity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Text-NER task in AutoML NLP vertical.
 * NER - Named Entity Recognition.
 * NLP - Natural Language Processing.
 * @property featurizationSettings Featurization inputs needed for AutoML job.
 * @property limitSettings Execution constraints for AutoMLJob.
 * @property logVerbosity Log verbosity for the job.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'TextNER'.
 * @property trainingData [Required] Training data input.
 * @property validationData Validation data inputs.
 */
public data class TextNerArgs(
    public val featurizationSettings: Output<NlpVerticalFeaturizationSettingsArgs>? = null,
    public val limitSettings: Output<NlpVerticalLimitSettingsArgs>? = null,
    public val logVerbosity: Output<Either<String, LogVerbosity>>? = null,
    public val targetColumnName: Output<String>? = null,
    public val taskType: Output<String>,
    public val trainingData: Output<MLTableJobInputArgs>,
    public val validationData: Output<MLTableJobInputArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.TextNerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.TextNerArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.TextNerArgs.builder()
            .featurizationSettings(
                featurizationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .limitSettings(limitSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logVerbosity(
                logVerbosity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetColumnName(targetColumnName?.applyValue({ args0 -> args0 }))
            .taskType(taskType.applyValue({ args0 -> args0 }))
            .trainingData(trainingData.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationData(
                validationData?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TextNerArgs].
 */
@PulumiTagMarker
public class TextNerArgsBuilder internal constructor() {
    private var featurizationSettings: Output<NlpVerticalFeaturizationSettingsArgs>? = null

    private var limitSettings: Output<NlpVerticalLimitSettingsArgs>? = null

    private var logVerbosity: Output<Either<String, LogVerbosity>>? = null

    private var targetColumnName: Output<String>? = null

    private var taskType: Output<String>? = null

    private var trainingData: Output<MLTableJobInputArgs>? = null

    private var validationData: Output<MLTableJobInputArgs>? = null

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("acmllaovwxcuyoiv")
    public suspend fun featurizationSettings(`value`: Output<NlpVerticalFeaturizationSettingsArgs>) {
        this.featurizationSettings = value
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("qicrqpubaajegijh")
    public suspend fun limitSettings(`value`: Output<NlpVerticalLimitSettingsArgs>) {
        this.limitSettings = value
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("dqttjjptjgtrphkg")
    public suspend fun logVerbosity(`value`: Output<Either<String, LogVerbosity>>) {
        this.logVerbosity = value
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("dtahuqacmkjxcduf")
    public suspend fun targetColumnName(`value`: Output<String>) {
        this.targetColumnName = value
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'TextNER'.
     */
    @JvmName("whhoullgttyevalk")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("simxrsopjpkouwfi")
    public suspend fun trainingData(`value`: Output<MLTableJobInputArgs>) {
        this.trainingData = value
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("xnepwvjfemxsikrq")
    public suspend fun validationData(`value`: Output<MLTableJobInputArgs>) {
        this.validationData = value
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("ccdhscokmgmqrerm")
    public suspend fun featurizationSettings(`value`: NlpVerticalFeaturizationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featurizationSettings = mapped
    }

    /**
     * @param argument Featurization inputs needed for AutoML job.
     */
    @JvmName("tcgikaktnmcwehth")
    public suspend
    fun featurizationSettings(argument: suspend NlpVerticalFeaturizationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NlpVerticalFeaturizationSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featurizationSettings = mapped
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("urxvmqcgbjcabhpq")
    public suspend fun limitSettings(`value`: NlpVerticalLimitSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitSettings = mapped
    }

    /**
     * @param argument Execution constraints for AutoMLJob.
     */
    @JvmName("rtrqkfcpucqkvkqe")
    public suspend
    fun limitSettings(argument: suspend NlpVerticalLimitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = NlpVerticalLimitSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limitSettings = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("rotexddngexibgjl")
    public suspend fun logVerbosity(`value`: Either<String, LogVerbosity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("dsjxuglwyxrnjvxp")
    public fun logVerbosity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("obqmepllvqfkxjea")
    public fun logVerbosity(`value`: LogVerbosity) {
        val toBeMapped = Either.ofRight<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("jilyxtlydyqqvkao")
    public suspend fun targetColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetColumnName = mapped
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'TextNER'.
     */
    @JvmName("adtsjgplvsdynpla")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("fgrbevvyvqicvfxq")
    public suspend fun trainingData(`value`: MLTableJobInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trainingData = mapped
    }

    /**
     * @param argument [Required] Training data input.
     */
    @JvmName("prapstehkhogfloe")
    public suspend fun trainingData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingData = mapped
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("tanflcdwriagblxc")
    public suspend fun validationData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param argument Validation data inputs.
     */
    @JvmName("njvfbkajakvtochh")
    public suspend fun validationData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationData = mapped
    }

    internal fun build(): TextNerArgs = TextNerArgs(
        featurizationSettings = featurizationSettings,
        limitSettings = limitSettings,
        logVerbosity = logVerbosity,
        targetColumnName = targetColumnName,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        trainingData = trainingData ?: throw PulumiNullFieldException("trainingData"),
        validationData = validationData,
    )
}
