@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.UserCreatedStorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property armResourceId ARM ResourceId of a resource
 */
public data class UserCreatedStorageAccountArgs(
    public val armResourceId: Output<ArmResourceIdArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.UserCreatedStorageAccountArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.UserCreatedStorageAccountArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.UserCreatedStorageAccountArgs.builder()
            .armResourceId(armResourceId?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [UserCreatedStorageAccountArgs].
 */
@PulumiTagMarker
public class UserCreatedStorageAccountArgsBuilder internal constructor() {
    private var armResourceId: Output<ArmResourceIdArgs>? = null

    /**
     * @param value ARM ResourceId of a resource
     */
    @JvmName("mfxyqnuvphjevkyj")
    public suspend fun armResourceId(`value`: Output<ArmResourceIdArgs>) {
        this.armResourceId = value
    }

    /**
     * @param value ARM ResourceId of a resource
     */
    @JvmName("ejxtwbmkjynmkwmt")
    public suspend fun armResourceId(`value`: ArmResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.armResourceId = mapped
    }

    /**
     * @param argument ARM ResourceId of a resource
     */
    @JvmName("xmylepjyiqtmturl")
    public suspend fun armResourceId(argument: suspend ArmResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ArmResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.armResourceId = mapped
    }

    internal fun build(): UserCreatedStorageAccountArgs = UserCreatedStorageAccountArgs(
        armResourceId = armResourceId,
    )
}
