@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.UserIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User identity configuration.
 * @property identityType Enum to determine identity framework.
 * Expected value is 'UserIdentity'.
 */
public data class UserIdentityArgs(
    public val identityType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.UserIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.UserIdentityArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.UserIdentityArgs.builder()
            .identityType(identityType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserIdentityArgs].
 */
@PulumiTagMarker
public class UserIdentityArgsBuilder internal constructor() {
    private var identityType: Output<String>? = null

    /**
     * @param value Enum to determine identity framework.
     * Expected value is 'UserIdentity'.
     */
    @JvmName("rkyamfglvaucfngp")
    public suspend fun identityType(`value`: Output<String>) {
        this.identityType = value
    }

    /**
     * @param value Enum to determine identity framework.
     * Expected value is 'UserIdentity'.
     */
    @JvmName("ascqoerjoiqialjm")
    public suspend fun identityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    internal fun build(): UserIdentityArgs = UserIdentityArgs(
        identityType = identityType ?: throw PulumiNullFieldException("identityType"),
    )
}
