@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ConnectionCategory
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ValueFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authType Authentication type of the connection target
 * Expected value is 'UsernamePassword'.
 * @property category Category of the connection
 * @property credentials
 * @property target
 * @property value Value details of the workspace connection.
 * @property valueFormat format for the workspace connection value
 */
public data class UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs(
    public val authType: Output<String>,
    public val category: Output<Either<String, ConnectionCategory>>? = null,
    public val credentials: Output<WorkspaceConnectionUsernamePasswordArgs>? = null,
    public val target: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val valueFormat: Output<Either<String, ValueFormat>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .valueFormat(
                valueFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var category: Output<Either<String, ConnectionCategory>>? = null

    private var credentials: Output<WorkspaceConnectionUsernamePasswordArgs>? = null

    private var target: Output<String>? = null

    private var `value`: Output<String>? = null

    private var valueFormat: Output<Either<String, ValueFormat>>? = null

    /**
     * @param value Authentication type of the connection target
     * Expected value is 'UsernamePassword'.
     */
    @JvmName("qvftqdlokkivrbrx")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("dsgqxbprikgouoqm")
    public suspend fun category(`value`: Output<Either<String, ConnectionCategory>>) {
        this.category = value
    }

    /**
     * @param value
     */
    @JvmName("bfqexknsumjdrhxa")
    public suspend fun credentials(`value`: Output<WorkspaceConnectionUsernamePasswordArgs>) {
        this.credentials = value
    }

    /**
     * @param value
     */
    @JvmName("wgfoosymyckuglom")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Value details of the workspace connection.
     */
    @JvmName("wsugmtstqheqoljt")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("xcghekubaaxhwgkv")
    public suspend fun valueFormat(`value`: Output<Either<String, ValueFormat>>) {
        this.valueFormat = value
    }

    /**
     * @param value Authentication type of the connection target
     * Expected value is 'UsernamePassword'.
     */
    @JvmName("vrxlfgjmlvckgcen")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("abcqindvyqlluloh")
    public suspend fun category(`value`: Either<String, ConnectionCategory>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("iflefyxjlymskicc")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("bbessawelrkbtgwj")
    public fun category(`value`: ConnectionCategory) {
        val toBeMapped = Either.ofRight<String, ConnectionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value
     */
    @JvmName("qyxvyloifnoosucb")
    public suspend fun credentials(`value`: WorkspaceConnectionUsernamePasswordArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fapvciklnfinyydn")
    public suspend
    fun credentials(argument: suspend WorkspaceConnectionUsernamePasswordArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceConnectionUsernamePasswordArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value
     */
    @JvmName("bofirlqcepeomelp")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Value details of the workspace connection.
     */
    @JvmName("pugreiqeqglgalbu")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("rimusgcrhiuaxeee")
    public suspend fun valueFormat(`value`: Either<String, ValueFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("lkgyvimxatbjpecv")
    public fun valueFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValueFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("teerjrjvdbofcwav")
    public fun valueFormat(`value`: ValueFormat) {
        val toBeMapped = Either.ofRight<String, ValueFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    internal fun build(): UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs =
        UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs(
            authType = authType ?: throw PulumiNullFieldException("authType"),
            category = category,
            credentials = credentials,
            target = target,
            `value` = `value`,
            valueFormat = valueFormat,
        )
}
