@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ARM ResourceId of a resource
 * @property resourceId Arm ResourceId is in the format "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
 * or "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}"
 */
public data class ArmResourceIdResponse(
    public val resourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ArmResourceIdResponse):
            ArmResourceIdResponse = ArmResourceIdResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
