@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Retry settings for a batch inference operation.
 * @property maxRetries Maximum retry count for a mini-batch
 * @property timeout Invocation timeout for a mini-batch, in ISO 8601 format.
 */
public data class BatchRetrySettingsResponse(
    public val maxRetries: Int? = null,
    public val timeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.BatchRetrySettingsResponse):
            BatchRetrySettingsResponse = BatchRetrySettingsResponse(
            maxRetries = javaType.maxRetries().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
