@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration settings for Docker build context
 * @property contextUri [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation and may return blob or Git URIs.
 * <seealso href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />
 * @property dockerfilePath Path to the Dockerfile in the build context.
 * <seealso href="https://docs.docker.com/engine/reference/builder/" />
 */
public data class BuildContextResponse(
    public val contextUri: String,
    public val dockerfilePath: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.BuildContextResponse):
            BuildContextResponse = BuildContextResponse(
            contextUri = javaType.contextUri(),
            dockerfilePath = javaType.dockerfilePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
