@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Category:= CustomKeys
 * AuthType:= CustomKeys (as type discriminator)
 * Credentials:= {CustomKeys} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.CustomKeys
 * Target:= {any value}
 * Use Metadata property bag for ApiVersion and other metadata fields
 * @property authType Authentication type of the connection target
 * Expected value is 'CustomKeys'.
 * @property category Category of the connection
 * @property credentials Custom Keys credential object
 * @property expiryTime
 * @property metadata
 * @property target
 */
public data class CustomKeysWorkspaceConnectionPropertiesResponse(
    public val authType: String,
    public val category: String? = null,
    public val credentials: CustomKeysResponse? = null,
    public val expiryTime: String? = null,
    public val metadata: Any? = null,
    public val target: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CustomKeysWorkspaceConnectionPropertiesResponse):
            CustomKeysWorkspaceConnectionPropertiesResponse =
            CustomKeysWorkspaceConnectionPropertiesResponse(
                authType = javaType.authType(),
                category = javaType.category().map({ args0 -> args0 }).orElse(null),
                credentials = javaType.credentials().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CustomKeysResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                expiryTime = javaType.expiryTime().map({ args0 -> args0 }).orElse(null),
                metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
                target = javaType.target().map({ args0 -> args0 }).orElse(null),
            )
    }
}
