@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Container for data asset versions.
 * @property dataType [Required] Specifies the type of data.
 * @property description The asset description text.
 * @property isArchived Is the asset archived?
 * @property latestVersion The latest version inside this container.
 * @property nextVersion The next auto incremental version
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class DataContainerResponse(
    public val dataType: String,
    public val description: String? = null,
    public val isArchived: Boolean? = null,
    public val latestVersion: String,
    public val nextVersion: String,
    public val properties: Map<String, String>? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DataContainerResponse):
            DataContainerResponse = DataContainerResponse(
            dataType = javaType.dataType(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            latestVersion = javaType.latestVersion(),
            nextVersion = javaType.nextVersion(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
