@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reference to an asset via its path in a datastore.
 * @property datastoreId ARM resource ID of the datastore where the asset is located.
 * @property path The path of the file/directory in the datastore.
 * @property referenceType Enum to determine which reference method to use for an asset.
 * Expected value is 'DataPath'.
 */
public data class DataPathAssetReferenceResponse(
    public val datastoreId: String? = null,
    public val path: String? = null,
    public val referenceType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DataPathAssetReferenceResponse):
            DataPathAssetReferenceResponse = DataPathAssetReferenceResponse(
            datastoreId = javaType.datastoreId().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            referenceType = javaType.referenceType(),
        )
    }
}
