@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reference to better Dataset or a Definition
 * @property datasetId Unique Dataset identifier.
 * @property definitionVersion Definition Version
 */
public data class DatasetStateResponseDeprecatedBy(
    public val datasetId: String,
    public val definitionVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DatasetStateResponseDeprecatedBy):
            DatasetStateResponseDeprecatedBy = DatasetStateResponseDeprecatedBy(
            datasetId = javaType.datasetId(),
            definitionVersion = javaType.definitionVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
