@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property identity The identity that will be used to access the key vault for encryption at rest.
 * @property keyVaultProperties Customer Key vault properties.
 * @property status Indicates whether or not the encryption is enabled for the workspace.
 */
public data class EncryptionPropertyResponse(
    public val identity: IdentityForCmkResponse? = null,
    public val keyVaultProperties: EncryptionKeyVaultPropertiesResponse,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.EncryptionPropertyResponse):
            EncryptionPropertyResponse = EncryptionPropertyResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityForCmkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EncryptionKeyVaultPropertiesResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status(),
        )
    }
}
