@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the endpoint configuration for the container
 * @property hostIp Host IP over which the application is exposed from the container
 * @property name Name of the Endpoint
 * @property protocol Protocol over which communication will happen over this endpoint
 * @property published Port over which the application is exposed from container.
 * @property target Application port inside the container.
 */
public data class EndpointResponse(
    public val hostIp: String? = null,
    public val name: String? = null,
    public val protocol: String? = null,
    public val published: Int? = null,
    public val target: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.EndpointResponse):
            EndpointResponse = EndpointResponse(
            hostIp = javaType.hostIp().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            published = javaType.published().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
