@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Linked service.
 * @property id ResourceId of the link of the linked service.
 * @property identity Identity for the resource.
 * @property location location of the linked service.
 * @property name Friendly name of the linked service.
 * @property properties LinkedService specific properties.
 * @property type Resource type of linked service.
 */
public data class GetLinkedServiceResult(
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: LinkedServicePropsResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetLinkedServiceResult):
            GetLinkedServiceResult = GetLinkedServiceResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LinkedServicePropsResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
