@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * HDInsight compute properties
 * @property address Public IP address of the master node of the cluster.
 * @property administratorAccount Admin credentials for master node of the cluster
 * @property sshPort Port open for ssh connections on the master node of the cluster.
 */
public data class HDInsightPropertiesResponse(
    public val address: String? = null,
    public val administratorAccount: VirtualMachineSshCredentialsResponse? = null,
    public val sshPort: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.HDInsightPropertiesResponse):
            HDInsightPropertiesResponse = HDInsightPropertiesResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            administratorAccount = javaType.administratorAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.VirtualMachineSshCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sshPort = javaType.sshPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
