@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Returns metadata about the operating system image for this compute instance.
 * @property currentImageVersion Specifies the current operating system image version this compute instance is running on.
 * @property isLatestOsImageVersion Specifies whether this compute instance is running on the latest operating system image.
 * @property latestImageVersion Specifies the latest available operating system image version.
 */
public data class ImageMetadataResponse(
    public val currentImageVersion: String? = null,
    public val isLatestOsImageVersion: Boolean? = null,
    public val latestImageVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ImageMetadataResponse):
            ImageMetadataResponse = ImageMetadataResponse(
            currentImageVersion = javaType.currentImageVersion().map({ args0 -> args0 }).orElse(null),
            isLatestOsImageVersion = javaType.isLatestOsImageVersion().map({ args0 -> args0 }).orElse(null),
            latestImageVersion = javaType.latestImageVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
