@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Inference pool configuration
 * @property codeConfiguration Code configuration for the inference pool.
 * @property description Description of the resource.
 * @property environmentConfiguration EnvironmentConfiguration for the inference pool.
 * @property modelConfiguration ModelConfiguration for the inference pool.
 * @property nodeSkuType [Required] Compute instance type.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property provisioningState Provisioning state for the pool.
 * @property requestConfiguration Request configuration for the inference pool.
 */
public data class InferencePoolResponse(
    public val codeConfiguration: CodeConfigurationResponse? = null,
    public val description: String? = null,
    public val environmentConfiguration: PoolEnvironmentConfigurationResponse? = null,
    public val modelConfiguration: PoolModelConfigurationResponse? = null,
    public val nodeSkuType: String,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val requestConfiguration: RequestConfigurationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.InferencePoolResponse):
            InferencePoolResponse = InferencePoolResponse(
            codeConfiguration = javaType.codeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            environmentConfiguration = javaType.environmentConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.PoolEnvironmentConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            modelConfiguration = javaType.modelConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.PoolModelConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nodeSkuType = javaType.nodeSkuType(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            requestConfiguration = javaType.requestConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RequestConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
