@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Label class definition
 * @property displayName Display name of the label class.
 * @property subclasses Dictionary of subclasses of the label class.
 */
public data class LabelClassResponse(
    public val displayName: String? = null,
    public val subclasses: Map<String, LabelClassResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LabelClassResponse):
            LabelClassResponse = LabelClassResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            subclasses = javaType.subclasses().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelClassResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
