@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Labeling data configuration definition
 * @property dataId Resource Id of the data asset to perform labeling.
 * @property incrementalDataRefresh Indicates whether to enable incremental data refresh.
 */
public data class LabelingDataConfigurationResponse(
    public val dataId: String? = null,
    public val incrementalDataRefresh: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LabelingDataConfigurationResponse):
            LabelingDataConfigurationResponse = LabelingDataConfigurationResponse(
            dataId = javaType.dataId().map({ args0 -> args0 }).orElse(null),
            incrementalDataRefresh = javaType.incrementalDataRefresh().map({ args0 -> args0 }).orElse(null),
        )
    }
}
