@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Labeling job definition
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property createdDateTime Created time of the job in UTC timezone.
 * @property dataConfiguration Configuration of data used in the job.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property isArchived Is the asset archived?
 * @property jobInstructions Labeling instructions of the job.
 * @property jobType Enum to determine the type of job.
 * Expected value is 'Labeling'.
 * @property labelCategories Label categories of the job.
 * @property labelingJobMediaProperties Media type specific properties in the job.
 * @property mlAssistConfiguration Configuration of MLAssist feature in the job.
 * @property notificationSetting Notification setting for the job
 * @property progressMetrics Progress metrics of the job.
 * @property projectId Internal id of the job(Previously called project).
 * @property properties The asset property dictionary.
 * @property provisioningState Specifies the labeling job provisioning state.
 * @property secretsConfiguration Configuration for secrets to be made available during runtime.
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property status Status of the job.
 * @property statusMessages Status messages of the job.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class LabelingJobResponse(
    public val componentId: String? = null,
    public val computeId: String? = null,
    public val createdDateTime: String,
    public val dataConfiguration: LabelingDataConfigurationResponse? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val experimentName: String? = null,
    public val identity: Any? = null,
    public val isArchived: Boolean? = null,
    public val jobInstructions: LabelingJobInstructionsResponse? = null,
    public val jobType: String,
    public val labelCategories: Map<String, LabelCategoryResponse>? = null,
    public val labelingJobMediaProperties:
    Either<LabelingJobImagePropertiesResponse, LabelingJobTextPropertiesResponse>? = null,
    public val mlAssistConfiguration:
    Either<MLAssistConfigurationDisabledResponse, MLAssistConfigurationEnabledResponse>? = null,
    public val notificationSetting: NotificationSettingResponse? = null,
    public val progressMetrics: ProgressMetricsResponse,
    public val projectId: String,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val secretsConfiguration: Map<String, SecretConfigurationResponse>? = null,
    public val services: Map<String, JobServiceResponse>? = null,
    public val status: String,
    public val statusMessages: List<StatusMessageResponse>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LabelingJobResponse):
            LabelingJobResponse = LabelingJobResponse(
            componentId = javaType.componentId().map({ args0 -> args0 }).orElse(null),
            computeId = javaType.computeId().map({ args0 -> args0 }).orElse(null),
            createdDateTime = javaType.createdDateTime(),
            dataConfiguration = javaType.dataConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelingDataConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            experimentName = javaType.experimentName().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            jobInstructions = javaType.jobInstructions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelingJobInstructionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jobType = javaType.jobType(),
            labelCategories = javaType.labelCategories().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelCategoryResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            labelingJobMediaProperties = javaType.labelingJobMediaProperties().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelingJobImagePropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelingJobTextPropertiesResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            mlAssistConfiguration = javaType.mlAssistConfiguration().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLAssistConfigurationDisabledResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MLAssistConfigurationEnabledResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            notificationSetting = javaType.notificationSetting().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NotificationSettingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            progressMetrics = javaType.progressMetrics().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ProgressMetricsResponse.Companion.toKotlin(args0)
            }),
            projectId = javaType.projectId(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            secretsConfiguration = javaType.secretsConfiguration().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SecretConfigurationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            services = javaType.services().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobServiceResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            status = javaType.status(),
            statusMessages = javaType.statusMessages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.StatusMessageResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
