@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A paginated list of FeaturesetJob entities.
 * @property nextLink The link to the next page of FeaturesetJob objects. If null, there are no additional pages.
 * @property value An array of objects of type FeaturesetJob.
 */
public data class ListFeaturesetVersionMaterializationJobsResult(
    public val nextLink: String? = null,
    public val `value`: List<FeaturesetJobResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ListFeaturesetVersionMaterializationJobsResult):
            ListFeaturesetVersionMaterializationJobsResult =
            ListFeaturesetVersionMaterializationJobsResult(
                nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeaturesetJobResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
