@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property failureReason The failure reason if the creation failed.
 * @property provisioningState Read-only provision state status property.
 * @property type Kind of the deployment.
 * Expected value is 'managedOnlineEndpoint'.
 */
public data class ManagedOnlineEndpointDeploymentResourcePropertiesResponse(
    public val failureReason: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ManagedOnlineEndpointDeploymentResourcePropertiesResponse):
            ManagedOnlineEndpointDeploymentResourcePropertiesResponse =
            ManagedOnlineEndpointDeploymentResourcePropertiesResponse(
                failureReason = javaType.failureReason().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
