@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines an early termination policy based on running averages of the primary metric of all runs
 * @property delayEvaluation Number of intervals by which to delay the first evaluation.
 * @property evaluationInterval Interval (number of runs) between policy evaluations.
 * @property policyType
 * Expected value is 'MedianStopping'.
 */
public data class MedianStoppingPolicyResponse(
    public val delayEvaluation: Int? = null,
    public val evaluationInterval: Int? = null,
    public val policyType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.MedianStoppingPolicyResponse):
            MedianStoppingPolicyResponse = MedianStoppingPolicyResponse(
            delayEvaluation = javaType.delayEvaluation().map({ args0 -> args0 }).orElse(null),
            evaluationInterval = javaType.evaluationInterval().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType(),
        )
    }
}
