@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * MPI distribution configuration.
 * @property distributionType Enum to determine the job distribution type.
 * Expected value is 'Mpi'.
 * @property processCountPerInstance Number of processes per MPI node.
 */
public data class MpiResponse(
    public val distributionType: String,
    public val processCountPerInstance: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.MpiResponse):
            MpiResponse = MpiResponse(
            distributionType = javaType.distributionType(),
            processCountPerInstance = javaType.processCountPerInstance().map({ args0 -> args0 }).orElse(null),
        )
    }
}
