@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Optimization objective.
 * @property goal [Required] Defines supported metric goals for hyperparameter tuning
 * @property primaryMetric [Required] Name of the metric to optimize.
 */
public data class ObjectiveResponse(
    public val goal: String,
    public val primaryMetric: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ObjectiveResponse):
            ObjectiveResponse = ObjectiveResponse(
            goal = javaType.goal(),
            primaryMetric = javaType.primaryMetric(),
        )
    }
}
