@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Environment configuration options.
 * @property environmentId ARM resource ID of the environment specification for the inference pool.
 * @property environmentVariables Environment variables configuration for the inference pool.
 * @property livenessProbe Liveness probe monitors the health of the container regularly.
 * @property readinessProbe Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
 * @property startupProbe This verifies whether the application within a container is started. Startup probes run before any other probe, and, unless it finishes successfully, disables other probes.
 */
public data class PoolEnvironmentConfigurationResponse(
    public val environmentId: String? = null,
    public val environmentVariables: Map<String, String>? = null,
    public val livenessProbe: ProbeSettingsResponse? = null,
    public val readinessProbe: ProbeSettingsResponse? = null,
    public val startupProbe: ProbeSettingsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.PoolEnvironmentConfigurationResponse):
            PoolEnvironmentConfigurationResponse = PoolEnvironmentConfigurationResponse(
            environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            livenessProbe = javaType.livenessProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ProbeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readinessProbe = javaType.readinessProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ProbeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startupProbe = javaType.startupProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ProbeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
