@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The PE network resource that is linked to this PE connection.
 * @property id The ARM identifier for Private Endpoint
 * @property subnetArmId The subnetId that the private endpoint is connected to.
 */
public data class PrivateEndpointResourceResponse(
    public val id: String,
    public val subnetArmId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.PrivateEndpointResourceResponse):
            PrivateEndpointResourceResponse = PrivateEndpointResourceResponse(
            id = javaType.id(),
            subnetArmId = javaType.subnetArmId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
