@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines a Sampling Algorithm that generates values randomly
 * @property rule The specific type of random algorithm
 * @property samplingAlgorithmType
 * Expected value is 'Random'.
 * @property seed An optional integer to use as the seed for random number generation
 */
public data class RandomSamplingAlgorithmResponse(
    public val rule: String? = null,
    public val samplingAlgorithmType: String,
    public val seed: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RandomSamplingAlgorithmResponse):
            RandomSamplingAlgorithmResponse = RandomSamplingAlgorithmResponse(
            rule = javaType.rule().map({ args0 -> args0 }).orElse(null),
            samplingAlgorithmType = javaType.samplingAlgorithmType(),
            seed = javaType.seed().map({ args0 -> args0 }).orElse(null),
        )
    }
}
