@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the Private Endpoint Connection
 * @property groupIds The group ids
 * @property privateEndpoint The PE network resource that is linked to this PE connection.
 * @property privateLinkServiceConnectionState The connection state.
 * @property provisioningState One of null, "Succeeded", "Provisioning", "Failed". While not approved, it's null.
 */
public data class RegistryPrivateEndpointConnectionPropertiesResponse(
    public val groupIds: List<String>? = null,
    public val privateEndpoint: PrivateEndpointResourceResponse? = null,
    public val privateLinkServiceConnectionState: RegistryPrivateLinkServiceConnectionStateResponse? =
        null,
    public val provisioningState: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RegistryPrivateEndpointConnectionPropertiesResponse):
            RegistryPrivateEndpointConnectionPropertiesResponse =
            RegistryPrivateEndpointConnectionPropertiesResponse(
                groupIds = javaType.groupIds().map({ args0 -> args0 }),
                privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.PrivateEndpointResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RegistryPrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            )
    }
}
