@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Scoring requests configuration.
 * @property maxConcurrentRequestsPerInstance The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
 * @property requestTimeout The scoring timeout in ISO 8601 format.
 * Defaults to 5000ms.
 */
public data class RequestConfigurationResponse(
    public val maxConcurrentRequestsPerInstance: Int? = null,
    public val requestTimeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RequestConfigurationResponse):
            RequestConfigurationResponse = RequestConfigurationResponse(
            maxConcurrentRequestsPerInstance = javaType.maxConcurrentRequestsPerInstance().map({ args0 ->
                args0
            }).orElse(null),
            requestTimeout = javaType.requestTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
