@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.ConfigurationAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration Assignment
 * Azure REST API version: 2022-11-01-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2023-04-01, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### ConfigurationAssignments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationAssignment = new AzureNative.Maintenance.ConfigurationAssignment("configurationAssignment", new()
 *     {
 *         ConfigurationAssignmentName = "workervmConfiguration",
 *         MaintenanceConfigurationId = "/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1",
 *         ProviderName = "Microsoft.Compute",
 *         ResourceGroupName = "examplerg",
 *         ResourceName = "smdtest1",
 *         ResourceType = "virtualMachineScaleSets",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maintenance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maintenance.NewConfigurationAssignment(ctx, "configurationAssignment", &maintenance.ConfigurationAssignmentArgs{
 * 			ConfigurationAssignmentName: pulumi.String("workervmConfiguration"),
 * 			MaintenanceConfigurationId:  pulumi.String("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1"),
 * 			ProviderName:                pulumi.String("Microsoft.Compute"),
 * 			ResourceGroupName:           pulumi.String("examplerg"),
 * 			ResourceName:                pulumi.String("smdtest1"),
 * 			ResourceType:                pulumi.String("virtualMachineScaleSets"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignment;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationAssignment = new ConfigurationAssignment("configurationAssignment", ConfigurationAssignmentArgs.builder()
 *             .configurationAssignmentName("workervmConfiguration")
 *             .maintenanceConfigurationId("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1")
 *             .providerName("Microsoft.Compute")
 *             .resourceGroupName("examplerg")
 *             .resourceName("smdtest1")
 *             .resourceType("virtualMachineScaleSets")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maintenance:ConfigurationAssignment workervmConfiguration /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}
 * ```
 * @property configurationAssignmentName Configuration assignment name
 * @property location Location of the resource
 * @property maintenanceConfigurationId The maintenance configuration Id
 * @property providerName Resource provider name
 * @property resourceGroupName Resource group name
 * @property resourceId The unique resourceId
 * @property resourceName Resource identifier
 * @property resourceType Resource type
 */
public data class ConfigurationAssignmentArgs(
    public val configurationAssignmentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val maintenanceConfigurationId: Output<String>? = null,
    public val providerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.ConfigurationAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.maintenance.ConfigurationAssignmentArgs =
        com.pulumi.azurenative.maintenance.ConfigurationAssignmentArgs.builder()
            .configurationAssignmentName(configurationAssignmentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceConfigurationId(maintenanceConfigurationId?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationAssignmentArgs].
 */
@PulumiTagMarker
public class ConfigurationAssignmentArgsBuilder internal constructor() {
    private var configurationAssignmentName: Output<String>? = null

    private var location: Output<String>? = null

    private var maintenanceConfigurationId: Output<String>? = null

    private var providerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value Configuration assignment name
     */
    @JvmName("eiktondsdenuidcv")
    public suspend fun configurationAssignmentName(`value`: Output<String>) {
        this.configurationAssignmentName = value
    }

    /**
     * @param value Location of the resource
     */
    @JvmName("eydqxccskaesnjbp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The maintenance configuration Id
     */
    @JvmName("fqbthhaghgxgpumt")
    public suspend fun maintenanceConfigurationId(`value`: Output<String>) {
        this.maintenanceConfigurationId = value
    }

    /**
     * @param value Resource provider name
     */
    @JvmName("bxnlcnnffcldyrfl")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value Resource group name
     */
    @JvmName("klprgmhykwskiebu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The unique resourceId
     */
    @JvmName("dsgyyjeykmhpkhwr")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Resource identifier
     */
    @JvmName("moywehklrbqxtluy")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource type
     */
    @JvmName("jkebdwldlqjqgigp")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Configuration assignment name
     */
    @JvmName("hxfgovgeypvynhqb")
    public suspend fun configurationAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationAssignmentName = mapped
    }

    /**
     * @param value Location of the resource
     */
    @JvmName("vlgnbytqasthvpkc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The maintenance configuration Id
     */
    @JvmName("nrcvpbkkxgwulhma")
    public suspend fun maintenanceConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceConfigurationId = mapped
    }

    /**
     * @param value Resource provider name
     */
    @JvmName("cgtewqnwkibyfsfi")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value Resource group name
     */
    @JvmName("yqybcfqasydcnpes")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The unique resourceId
     */
    @JvmName("rbfyfuyqsmikmrhk")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Resource identifier
     */
    @JvmName("ogfnpcbevqybctwn")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource type
     */
    @JvmName("ovlfaxnghjnriqnv")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): ConfigurationAssignmentArgs = ConfigurationAssignmentArgs(
        configurationAssignmentName = configurationAssignmentName,
        location = location,
        maintenanceConfigurationId = maintenanceConfigurationId,
        providerName = providerName,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        resourceName = resourceName,
        resourceType = resourceType,
    )
}
