@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.MaintenanceFunctions.getConfigurationAssignmentParentPlain
import com.pulumi.azurenative.maintenance.MaintenanceFunctions.getConfigurationAssignmentPlain
import com.pulumi.azurenative.maintenance.MaintenanceFunctions.getConfigurationAssignmentsForResourceGroupPlain
import com.pulumi.azurenative.maintenance.MaintenanceFunctions.getConfigurationAssignmentsForSubscriptionPlain
import com.pulumi.azurenative.maintenance.MaintenanceFunctions.getMaintenanceConfigurationPlain
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetConfigurationAssignmentParentPlainArgs
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetConfigurationAssignmentParentPlainArgsBuilder
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetConfigurationAssignmentPlainArgs
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetConfigurationAssignmentPlainArgsBuilder
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetConfigurationAssignmentsForResourceGroupPlainArgs
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetConfigurationAssignmentsForResourceGroupPlainArgsBuilder
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetConfigurationAssignmentsForSubscriptionPlainArgs
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetConfigurationAssignmentsForSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetMaintenanceConfigurationPlainArgs
import com.pulumi.azurenative.maintenance.kotlin.inputs.GetMaintenanceConfigurationPlainArgsBuilder
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetConfigurationAssignmentParentResult
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetConfigurationAssignmentResult
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetConfigurationAssignmentsForResourceGroupResult
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetConfigurationAssignmentsForSubscriptionResult
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetMaintenanceConfigurationResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetConfigurationAssignmentParentResult.Companion.toKotlin as getConfigurationAssignmentParentResultToKotlin
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetConfigurationAssignmentResult.Companion.toKotlin as getConfigurationAssignmentResultToKotlin
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetConfigurationAssignmentsForResourceGroupResult.Companion.toKotlin as getConfigurationAssignmentsForResourceGroupResultToKotlin
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetConfigurationAssignmentsForSubscriptionResult.Companion.toKotlin as getConfigurationAssignmentsForSubscriptionResultToKotlin
import com.pulumi.azurenative.maintenance.kotlin.outputs.GetMaintenanceConfigurationResult.Companion.toKotlin as getMaintenanceConfigurationResultToKotlin

public object MaintenanceFunctions {
    /**
     * Get configuration for resource.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-04-01, 2023-09-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return Configuration Assignment
     */
    public suspend fun getConfigurationAssignment(argument: GetConfigurationAssignmentPlainArgs):
        GetConfigurationAssignmentResult =
        getConfigurationAssignmentResultToKotlin(getConfigurationAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationAssignment].
     * @param configurationAssignmentName Configuration assignment name
     * @param providerName Resource provider name
     * @param resourceGroupName Resource group name
     * @param resourceName Resource identifier
     * @param resourceType Resource type
     * @return Configuration Assignment
     */
    public suspend fun getConfigurationAssignment(
        configurationAssignmentName: String,
        providerName: String,
        resourceGroupName: String,
        resourceName: String,
        resourceType: String,
    ): GetConfigurationAssignmentResult {
        val argument = GetConfigurationAssignmentPlainArgs(
            configurationAssignmentName = configurationAssignmentName,
            providerName = providerName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            resourceType = resourceType,
        )
        return getConfigurationAssignmentResultToKotlin(getConfigurationAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maintenance&#46;kotlin&#46;inputs&#46;GetConfigurationAssignmentPlainArgs].
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignment(argument: suspend GetConfigurationAssignmentPlainArgsBuilder.() -> Unit):
        GetConfigurationAssignmentResult {
        val builder = GetConfigurationAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationAssignmentResultToKotlin(getConfigurationAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get configuration for resource.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-04-01, 2023-09-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignmentParent(argument: GetConfigurationAssignmentParentPlainArgs):
        GetConfigurationAssignmentParentResult =
        getConfigurationAssignmentParentResultToKotlin(getConfigurationAssignmentParentPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationAssignmentParent].
     * @param configurationAssignmentName Configuration assignment name
     * @param providerName Resource provider name
     * @param resourceGroupName Resource group name
     * @param resourceName Resource identifier
     * @param resourceParentName Resource parent identifier
     * @param resourceParentType Resource parent type
     * @param resourceType Resource type
     * @return Configuration Assignment
     */
    public suspend fun getConfigurationAssignmentParent(
        configurationAssignmentName: String,
        providerName: String,
        resourceGroupName: String,
        resourceName: String,
        resourceParentName: String,
        resourceParentType: String,
        resourceType: String,
    ): GetConfigurationAssignmentParentResult {
        val argument = GetConfigurationAssignmentParentPlainArgs(
            configurationAssignmentName = configurationAssignmentName,
            providerName = providerName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            resourceParentName = resourceParentName,
            resourceParentType = resourceParentType,
            resourceType = resourceType,
        )
        return getConfigurationAssignmentParentResultToKotlin(getConfigurationAssignmentParentPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationAssignmentParent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maintenance&#46;kotlin&#46;inputs&#46;GetConfigurationAssignmentParentPlainArgs].
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignmentParent(argument: suspend GetConfigurationAssignmentParentPlainArgsBuilder.() -> Unit):
        GetConfigurationAssignmentParentResult {
        val builder = GetConfigurationAssignmentParentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationAssignmentParentResultToKotlin(getConfigurationAssignmentParentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get configuration assignment for resource..
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-09-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignmentsForResourceGroup(argument: GetConfigurationAssignmentsForResourceGroupPlainArgs):
        GetConfigurationAssignmentsForResourceGroupResult =
        getConfigurationAssignmentsForResourceGroupResultToKotlin(getConfigurationAssignmentsForResourceGroupPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationAssignmentsForResourceGroup].
     * @param configurationAssignmentName Configuration assignment name
     * @param resourceGroupName Resource group name
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignmentsForResourceGroup(
        configurationAssignmentName: String,
        resourceGroupName: String,
    ): GetConfigurationAssignmentsForResourceGroupResult {
        val argument = GetConfigurationAssignmentsForResourceGroupPlainArgs(
            configurationAssignmentName = configurationAssignmentName,
            resourceGroupName = resourceGroupName,
        )
        return getConfigurationAssignmentsForResourceGroupResultToKotlin(getConfigurationAssignmentsForResourceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationAssignmentsForResourceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maintenance&#46;kotlin&#46;inputs&#46;GetConfigurationAssignmentsForResourceGroupPlainArgs].
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignmentsForResourceGroup(argument: suspend GetConfigurationAssignmentsForResourceGroupPlainArgsBuilder.() -> Unit):
        GetConfigurationAssignmentsForResourceGroupResult {
        val builder = GetConfigurationAssignmentsForResourceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationAssignmentsForResourceGroupResultToKotlin(getConfigurationAssignmentsForResourceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get configuration assignment for resource..
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-09-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignmentsForSubscription(argument: GetConfigurationAssignmentsForSubscriptionPlainArgs):
        GetConfigurationAssignmentsForSubscriptionResult =
        getConfigurationAssignmentsForSubscriptionResultToKotlin(getConfigurationAssignmentsForSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getConfigurationAssignmentsForSubscription].
     * @param configurationAssignmentName Configuration assignment name
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignmentsForSubscription(configurationAssignmentName: String):
        GetConfigurationAssignmentsForSubscriptionResult {
        val argument = GetConfigurationAssignmentsForSubscriptionPlainArgs(
            configurationAssignmentName = configurationAssignmentName,
        )
        return getConfigurationAssignmentsForSubscriptionResultToKotlin(getConfigurationAssignmentsForSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationAssignmentsForSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maintenance&#46;kotlin&#46;inputs&#46;GetConfigurationAssignmentsForSubscriptionPlainArgs].
     * @return Configuration Assignment
     */
    public suspend
    fun getConfigurationAssignmentsForSubscription(argument: suspend GetConfigurationAssignmentsForSubscriptionPlainArgsBuilder.() -> Unit):
        GetConfigurationAssignmentsForSubscriptionResult {
        val builder = GetConfigurationAssignmentsForSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationAssignmentsForSubscriptionResultToKotlin(getConfigurationAssignmentsForSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Maintenance configuration record type
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-04-01, 2023-09-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return Maintenance configuration record type
     */
    public suspend fun getMaintenanceConfiguration(argument: GetMaintenanceConfigurationPlainArgs):
        GetMaintenanceConfigurationResult =
        getMaintenanceConfigurationResultToKotlin(getMaintenanceConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getMaintenanceConfiguration].
     * @param resourceGroupName Resource Group Name
     * @param resourceName Maintenance Configuration Name
     * @return Maintenance configuration record type
     */
    public suspend fun getMaintenanceConfiguration(resourceGroupName: String, resourceName: String):
        GetMaintenanceConfigurationResult {
        val argument = GetMaintenanceConfigurationPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getMaintenanceConfigurationResultToKotlin(getMaintenanceConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getMaintenanceConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;maintenance&#46;kotlin&#46;inputs&#46;GetMaintenanceConfigurationPlainArgs].
     * @return Maintenance configuration record type
     */
    public suspend
    fun getMaintenanceConfiguration(argument: suspend GetMaintenanceConfigurationPlainArgsBuilder.() -> Unit):
        GetMaintenanceConfigurationResult {
        val builder = GetMaintenanceConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMaintenanceConfigurationResultToKotlin(getMaintenanceConfigurationPlain(builtArgument.toJava()).await())
    }
}
