@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
 */
public enum class RebootOptions(
    public val javaValue: com.pulumi.azurenative.maintenance.enums.RebootOptions,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.enums.RebootOptions> {
    IfRequired(com.pulumi.azurenative.maintenance.enums.RebootOptions.IfRequired),
    Never(com.pulumi.azurenative.maintenance.enums.RebootOptions.Never),
    Always(com.pulumi.azurenative.maintenance.enums.RebootOptions.Always),
    ;

    override fun toJava(): com.pulumi.azurenative.maintenance.enums.RebootOptions = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.maintenance.enums.RebootOptions):
            RebootOptions = RebootOptions.values().first { it.javaValue == javaType }
    }
}
