@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationAssignmentName Configuration assignment name
 * @property providerName Resource provider name
 * @property resourceGroupName Resource group name
 * @property resourceName Resource identifier
 * @property resourceType Resource type
 */
public data class GetConfigurationAssignmentPlainArgs(
    public val configurationAssignmentName: String,
    public val providerName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val resourceType: String,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentPlainArgs =
        com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentPlainArgs.builder()
            .configurationAssignmentName(configurationAssignmentName.let({ args0 -> args0 }))
            .providerName(providerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationAssignmentPlainArgsBuilder internal constructor() {
    private var configurationAssignmentName: String? = null

    private var providerName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var resourceType: String? = null

    /**
     * @param value Configuration assignment name
     */
    @JvmName("preneonpyakislji")
    public suspend fun configurationAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationAssignmentName = mapped
    }

    /**
     * @param value Resource provider name
     */
    @JvmName("pqkyydyhsmucntbx")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerName = mapped
    }

    /**
     * @param value Resource group name
     */
    @JvmName("xmqoaykqahdmnckc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource identifier
     */
    @JvmName("vjqtylbjcrtrlcmt")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value Resource type
     */
    @JvmName("ouiabvtojtnplxpm")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetConfigurationAssignmentPlainArgs = GetConfigurationAssignmentPlainArgs(
        configurationAssignmentName = configurationAssignmentName ?: throw
            PulumiNullFieldException("configurationAssignmentName"),
        providerName = providerName ?: throw PulumiNullFieldException("providerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
