@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.InputWindowsParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input properties for patching a Windows machine.
 * @property classificationsToInclude Classification category of patches to be patched
 * @property excludeKbsRequiringReboot Exclude patches which need reboot
 * @property kbNumbersToExclude Windows KBID to be excluded for patching.
 * @property kbNumbersToInclude Windows KBID to be included for patching.
 */
public data class InputWindowsParametersArgs(
    public val classificationsToInclude: Output<List<String>>? = null,
    public val excludeKbsRequiringReboot: Output<Boolean>? = null,
    public val kbNumbersToExclude: Output<List<String>>? = null,
    public val kbNumbersToInclude: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.InputWindowsParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.maintenance.inputs.InputWindowsParametersArgs =
        com.pulumi.azurenative.maintenance.inputs.InputWindowsParametersArgs.builder()
            .classificationsToInclude(
                classificationsToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .excludeKbsRequiringReboot(excludeKbsRequiringReboot?.applyValue({ args0 -> args0 }))
            .kbNumbersToExclude(kbNumbersToExclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kbNumbersToInclude(
                kbNumbersToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [InputWindowsParametersArgs].
 */
@PulumiTagMarker
public class InputWindowsParametersArgsBuilder internal constructor() {
    private var classificationsToInclude: Output<List<String>>? = null

    private var excludeKbsRequiringReboot: Output<Boolean>? = null

    private var kbNumbersToExclude: Output<List<String>>? = null

    private var kbNumbersToInclude: Output<List<String>>? = null

    /**
     * @param value Classification category of patches to be patched
     */
    @JvmName("vbcuextqpfjfvicy")
    public suspend fun classificationsToInclude(`value`: Output<List<String>>) {
        this.classificationsToInclude = value
    }

    @JvmName("bwtmhhiuarotjfgw")
    public suspend fun classificationsToInclude(vararg values: Output<String>) {
        this.classificationsToInclude = Output.all(values.asList())
    }

    /**
     * @param values Classification category of patches to be patched
     */
    @JvmName("cwqqpccfjyetvfux")
    public suspend fun classificationsToInclude(values: List<Output<String>>) {
        this.classificationsToInclude = Output.all(values)
    }

    /**
     * @param value Exclude patches which need reboot
     */
    @JvmName("ksjsrvgtdselfruj")
    public suspend fun excludeKbsRequiringReboot(`value`: Output<Boolean>) {
        this.excludeKbsRequiringReboot = value
    }

    /**
     * @param value Windows KBID to be excluded for patching.
     */
    @JvmName("uohvmxepnqgnambn")
    public suspend fun kbNumbersToExclude(`value`: Output<List<String>>) {
        this.kbNumbersToExclude = value
    }

    @JvmName("anlchaxoftkklbwh")
    public suspend fun kbNumbersToExclude(vararg values: Output<String>) {
        this.kbNumbersToExclude = Output.all(values.asList())
    }

    /**
     * @param values Windows KBID to be excluded for patching.
     */
    @JvmName("fsmwmfxgiwfugneu")
    public suspend fun kbNumbersToExclude(values: List<Output<String>>) {
        this.kbNumbersToExclude = Output.all(values)
    }

    /**
     * @param value Windows KBID to be included for patching.
     */
    @JvmName("yjdomwlrwgxtnjna")
    public suspend fun kbNumbersToInclude(`value`: Output<List<String>>) {
        this.kbNumbersToInclude = value
    }

    @JvmName("ebrxsybsjysirdmw")
    public suspend fun kbNumbersToInclude(vararg values: Output<String>) {
        this.kbNumbersToInclude = Output.all(values.asList())
    }

    /**
     * @param values Windows KBID to be included for patching.
     */
    @JvmName("icahbkghdpvmcgan")
    public suspend fun kbNumbersToInclude(values: List<Output<String>>) {
        this.kbNumbersToInclude = Output.all(values)
    }

    /**
     * @param value Classification category of patches to be patched
     */
    @JvmName("qdujfjknvjcvlxmw")
    public suspend fun classificationsToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classificationsToInclude = mapped
    }

    /**
     * @param values Classification category of patches to be patched
     */
    @JvmName("laokhgpspgvxcjgw")
    public suspend fun classificationsToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classificationsToInclude = mapped
    }

    /**
     * @param value Exclude patches which need reboot
     */
    @JvmName("rgakikjteuilpluw")
    public suspend fun excludeKbsRequiringReboot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeKbsRequiringReboot = mapped
    }

    /**
     * @param value Windows KBID to be excluded for patching.
     */
    @JvmName("tpbylvxxgjcovbyc")
    public suspend fun kbNumbersToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kbNumbersToExclude = mapped
    }

    /**
     * @param values Windows KBID to be excluded for patching.
     */
    @JvmName("cnqthgwixqnanogo")
    public suspend fun kbNumbersToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kbNumbersToExclude = mapped
    }

    /**
     * @param value Windows KBID to be included for patching.
     */
    @JvmName("pyciteceedkujvhv")
    public suspend fun kbNumbersToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kbNumbersToInclude = mapped
    }

    /**
     * @param values Windows KBID to be included for patching.
     */
    @JvmName("nvueveldmopbhlop")
    public suspend fun kbNumbersToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kbNumbersToInclude = mapped
    }

    internal fun build(): InputWindowsParametersArgs = InputWindowsParametersArgs(
        classificationsToInclude = classificationsToInclude,
        excludeKbsRequiringReboot = excludeKbsRequiringReboot,
        kbNumbersToExclude = kbNumbersToExclude,
        kbNumbersToInclude = kbNumbersToInclude,
    )
}
