@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin

import com.pulumi.azurenative.managedidentity.FederatedIdentityCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a federated identity credential.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2022-01-31-preview.
 * Other available API versions: 2023-07-31-preview.
 * ## Example Usage
 * ### FederatedIdentityCredentialCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var federatedIdentityCredential = new AzureNative.ManagedIdentity.FederatedIdentityCredential("federatedIdentityCredential", new()
 *     {
 *         Audiences = new[]
 *         {
 *             "api://AzureADTokenExchange",
 *         },
 *         FederatedIdentityCredentialResourceName = "ficResourceName",
 *         Issuer = "https://oidc.prod-aks.azure.com/TenantGUID/IssuerGUID",
 *         ResourceGroupName = "rgName",
 *         ResourceName = "resourceName",
 *         Subject = "system:serviceaccount:ns:svcaccount",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managedidentity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managedidentity.NewFederatedIdentityCredential(ctx, "federatedIdentityCredential", &managedidentity.FederatedIdentityCredentialArgs{
 * 			Audiences: pulumi.StringArray{
 * 				pulumi.String("api://AzureADTokenExchange"),
 * 			},
 * 			FederatedIdentityCredentialResourceName: pulumi.String("ficResourceName"),
 * 			Issuer:                                  pulumi.String("https://oidc.prod-aks.azure.com/TenantGUID/IssuerGUID"),
 * 			ResourceGroupName:                       pulumi.String("rgName"),
 * 			ResourceName:                            pulumi.String("resourceName"),
 * 			Subject:                                 pulumi.String("system:serviceaccount:ns:svcaccount"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managedidentity.FederatedIdentityCredential;
 * import com.pulumi.azurenative.managedidentity.FederatedIdentityCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var federatedIdentityCredential = new FederatedIdentityCredential("federatedIdentityCredential", FederatedIdentityCredentialArgs.builder()
 *             .audiences("api://AzureADTokenExchange")
 *             .federatedIdentityCredentialResourceName("ficResourceName")
 *             .issuer("https://oidc.prod-aks.azure.com/TenantGUID/IssuerGUID")
 *             .resourceGroupName("rgName")
 *             .resourceName("resourceName")
 *             .subject("system:serviceaccount:ns:svcaccount")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managedidentity:FederatedIdentityCredential ficResourceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials/{federatedIdentityCredentialResourceName}
 * ```
 * @property audiences The list of audiences that can appear in the issued token.
 * @property federatedIdentityCredentialResourceName The name of the federated identity credential resource.
 * @property issuer The URL of the issuer to be trusted.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the identity resource.
 * @property subject The identifier of the external identity.
 */
public data class FederatedIdentityCredentialArgs(
    public val audiences: Output<List<String>>? = null,
    public val federatedIdentityCredentialResourceName: Output<String>? = null,
    public val issuer: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val subject: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managedidentity.FederatedIdentityCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.managedidentity.FederatedIdentityCredentialArgs =
        com.pulumi.azurenative.managedidentity.FederatedIdentityCredentialArgs.builder()
            .audiences(audiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .federatedIdentityCredentialResourceName(
                federatedIdentityCredentialResourceName?.applyValue({ args0 ->
                    args0
                }),
            )
            .issuer(issuer?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .subject(subject?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FederatedIdentityCredentialArgs].
 */
@PulumiTagMarker
public class FederatedIdentityCredentialArgsBuilder internal constructor() {
    private var audiences: Output<List<String>>? = null

    private var federatedIdentityCredentialResourceName: Output<String>? = null

    private var issuer: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var subject: Output<String>? = null

    /**
     * @param value The list of audiences that can appear in the issued token.
     */
    @JvmName("denygmyghqcgauxx")
    public suspend fun audiences(`value`: Output<List<String>>) {
        this.audiences = value
    }

    @JvmName("opqynhwbvidnhdrt")
    public suspend fun audiences(vararg values: Output<String>) {
        this.audiences = Output.all(values.asList())
    }

    /**
     * @param values The list of audiences that can appear in the issued token.
     */
    @JvmName("swdnqiclikrkdmnu")
    public suspend fun audiences(values: List<Output<String>>) {
        this.audiences = Output.all(values)
    }

    /**
     * @param value The name of the federated identity credential resource.
     */
    @JvmName("nwdnbvjjhwvtsqpk")
    public suspend fun federatedIdentityCredentialResourceName(`value`: Output<String>) {
        this.federatedIdentityCredentialResourceName = value
    }

    /**
     * @param value The URL of the issuer to be trusted.
     */
    @JvmName("bpxsumkushhnxhrt")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ssiwvxtajwjeiseq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the identity resource.
     */
    @JvmName("xgojgipblxyewnwd")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The identifier of the external identity.
     */
    @JvmName("tvbmwqnshkqqksqe")
    public suspend fun subject(`value`: Output<String>) {
        this.subject = value
    }

    /**
     * @param value The list of audiences that can appear in the issued token.
     */
    @JvmName("fclodomphsmupplv")
    public suspend fun audiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param values The list of audiences that can appear in the issued token.
     */
    @JvmName("wdyxvjscpmbedhsr")
    public suspend fun audiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param value The name of the federated identity credential resource.
     */
    @JvmName("pwosacxvhakxbavm")
    public suspend fun federatedIdentityCredentialResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.federatedIdentityCredentialResourceName = mapped
    }

    /**
     * @param value The URL of the issuer to be trusted.
     */
    @JvmName("ekclemchjxbgllhh")
    public suspend fun issuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yqyrmlhiouibtniw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the identity resource.
     */
    @JvmName("achnalsnrrjkuiex")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The identifier of the external identity.
     */
    @JvmName("mvnmjxgnnlunetxk")
    public suspend fun subject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    internal fun build(): FederatedIdentityCredentialArgs = FederatedIdentityCredentialArgs(
        audiences = audiences,
        federatedIdentityCredentialResourceName = federatedIdentityCredentialResourceName,
        issuer = issuer,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        subject = subject,
    )
}
