@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin

import com.pulumi.azurenative.managedidentity.ManagedidentityFunctions.getFederatedIdentityCredentialPlain
import com.pulumi.azurenative.managedidentity.ManagedidentityFunctions.getUserAssignedIdentityPlain
import com.pulumi.azurenative.managedidentity.ManagedidentityFunctions.listUserAssignedIdentityAssociatedResourcesPlain
import com.pulumi.azurenative.managedidentity.kotlin.inputs.GetFederatedIdentityCredentialPlainArgs
import com.pulumi.azurenative.managedidentity.kotlin.inputs.GetFederatedIdentityCredentialPlainArgsBuilder
import com.pulumi.azurenative.managedidentity.kotlin.inputs.GetUserAssignedIdentityPlainArgs
import com.pulumi.azurenative.managedidentity.kotlin.inputs.GetUserAssignedIdentityPlainArgsBuilder
import com.pulumi.azurenative.managedidentity.kotlin.inputs.ListUserAssignedIdentityAssociatedResourcesPlainArgs
import com.pulumi.azurenative.managedidentity.kotlin.inputs.ListUserAssignedIdentityAssociatedResourcesPlainArgsBuilder
import com.pulumi.azurenative.managedidentity.kotlin.outputs.GetFederatedIdentityCredentialResult
import com.pulumi.azurenative.managedidentity.kotlin.outputs.GetUserAssignedIdentityResult
import com.pulumi.azurenative.managedidentity.kotlin.outputs.ListUserAssignedIdentityAssociatedResourcesResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.managedidentity.kotlin.outputs.GetFederatedIdentityCredentialResult.Companion.toKotlin as getFederatedIdentityCredentialResultToKotlin
import com.pulumi.azurenative.managedidentity.kotlin.outputs.GetUserAssignedIdentityResult.Companion.toKotlin as getUserAssignedIdentityResultToKotlin
import com.pulumi.azurenative.managedidentity.kotlin.outputs.ListUserAssignedIdentityAssociatedResourcesResult.Companion.toKotlin as listUserAssignedIdentityAssociatedResourcesResultToKotlin

public object ManagedidentityFunctions {
    /**
     * Gets the federated identity credential.
     * Azure REST API version: 2023-01-31.
     * Other available API versions: 2023-07-31-preview.
     * @param argument null
     * @return Describes a federated identity credential.
     */
    public suspend
    fun getFederatedIdentityCredential(argument: GetFederatedIdentityCredentialPlainArgs):
        GetFederatedIdentityCredentialResult =
        getFederatedIdentityCredentialResultToKotlin(getFederatedIdentityCredentialPlain(argument.toJava()).await())

    /**
     * @see [getFederatedIdentityCredential].
     * @param federatedIdentityCredentialResourceName The name of the federated identity credential resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the identity resource.
     * @return Describes a federated identity credential.
     */
    public suspend fun getFederatedIdentityCredential(
        federatedIdentityCredentialResourceName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetFederatedIdentityCredentialResult {
        val argument = GetFederatedIdentityCredentialPlainArgs(
            federatedIdentityCredentialResourceName = federatedIdentityCredentialResourceName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getFederatedIdentityCredentialResultToKotlin(getFederatedIdentityCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [getFederatedIdentityCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managedidentity&#46;kotlin&#46;inputs&#46;GetFederatedIdentityCredentialPlainArgs].
     * @return Describes a federated identity credential.
     */
    public suspend
    fun getFederatedIdentityCredential(argument: suspend GetFederatedIdentityCredentialPlainArgsBuilder.() -> Unit):
        GetFederatedIdentityCredentialResult {
        val builder = GetFederatedIdentityCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFederatedIdentityCredentialResultToKotlin(getFederatedIdentityCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the identity.
     * Azure REST API version: 2023-01-31.
     * Other available API versions: 2015-08-31-preview, 2023-07-31-preview.
     * @param argument null
     * @return Describes an identity resource.
     */
    public suspend fun getUserAssignedIdentity(argument: GetUserAssignedIdentityPlainArgs):
        GetUserAssignedIdentityResult =
        getUserAssignedIdentityResultToKotlin(getUserAssignedIdentityPlain(argument.toJava()).await())

    /**
     * @see [getUserAssignedIdentity].
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @return Describes an identity resource.
     */
    public suspend fun getUserAssignedIdentity(resourceGroupName: String, resourceName: String):
        GetUserAssignedIdentityResult {
        val argument = GetUserAssignedIdentityPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getUserAssignedIdentityResultToKotlin(getUserAssignedIdentityPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserAssignedIdentity].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managedidentity&#46;kotlin&#46;inputs&#46;GetUserAssignedIdentityPlainArgs].
     * @return Describes an identity resource.
     */
    public suspend
    fun getUserAssignedIdentity(argument: suspend GetUserAssignedIdentityPlainArgsBuilder.() -> Unit):
        GetUserAssignedIdentityResult {
        val builder = GetUserAssignedIdentityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserAssignedIdentityResultToKotlin(getUserAssignedIdentityPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the associated resources for this identity.
     * Azure REST API version: 2022-01-31-preview.
     * @param argument null
     * @return Azure resources returned by the resource action to get a list of assigned resources.
     */
    public suspend
    fun listUserAssignedIdentityAssociatedResources(argument: ListUserAssignedIdentityAssociatedResourcesPlainArgs):
        ListUserAssignedIdentityAssociatedResourcesResult =
        listUserAssignedIdentityAssociatedResourcesResultToKotlin(listUserAssignedIdentityAssociatedResourcesPlain(argument.toJava()).await())

    /**
     * @see [listUserAssignedIdentityAssociatedResources].
     * @param filter OData filter expression to apply to the query.
     * @param orderby OData orderBy expression to apply to the query.
     * @param resourceGroupName The name of the Resource Group to which the identity belongs.
     * @param resourceName The name of the identity resource.
     * @param skip Number of records to skip.
     * @param skiptoken A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies a starting point to use for subsequent calls.
     * @param top Number of records to return.
     * @return Azure resources returned by the resource action to get a list of assigned resources.
     */
    public suspend fun listUserAssignedIdentityAssociatedResources(
        filter: String? = null,
        orderby: String? = null,
        resourceGroupName: String,
        resourceName: String,
        skip: Int? = null,
        skiptoken: String? = null,
        top: Int? = null,
    ): ListUserAssignedIdentityAssociatedResourcesResult {
        val argument = ListUserAssignedIdentityAssociatedResourcesPlainArgs(
            filter = filter,
            orderby = orderby,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            skip = skip,
            skiptoken = skiptoken,
            top = top,
        )
        return listUserAssignedIdentityAssociatedResourcesResultToKotlin(listUserAssignedIdentityAssociatedResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [listUserAssignedIdentityAssociatedResources].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managedidentity&#46;kotlin&#46;inputs&#46;ListUserAssignedIdentityAssociatedResourcesPlainArgs].
     * @return Azure resources returned by the resource action to get a list of assigned resources.
     */
    public suspend
    fun listUserAssignedIdentityAssociatedResources(argument: suspend ListUserAssignedIdentityAssociatedResourcesPlainArgsBuilder.() -> Unit):
        ListUserAssignedIdentityAssociatedResourcesResult {
        val builder = ListUserAssignedIdentityAssociatedResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listUserAssignedIdentityAssociatedResourcesResultToKotlin(listUserAssignedIdentityAssociatedResourcesPlain(builtArgument.toJava()).await())
    }
}
