@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse
import com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ManagedNetworkGroup].
 */
@PulumiTagMarker
public class ManagedNetworkGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedNetworkGroupArgs = ManagedNetworkGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedNetworkGroupArgsBuilder.() -> Unit) {
        val builder = ManagedNetworkGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedNetworkGroup {
        val builtJavaResource =
            com.pulumi.azurenative.managednetwork.ManagedNetworkGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedNetworkGroup(builtJavaResource)
    }
}

/**
 * The Managed Network Group resource
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### ManagementNetworkGroupsPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedNetworkGroup = new AzureNative.ManagedNetwork.ManagedNetworkGroup("managedNetworkGroup", new()
 *     {
 *         ManagedNetworkGroupName = "myManagedNetworkGroup1",
 *         ManagedNetworkName = "myManagedNetwork",
 *         ManagementGroups = new[] {},
 *         ResourceGroupName = "myResourceGroup",
 *         Subnets = new[]
 *         {
 *             new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *             {
 *                 Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA/subnets/subnetA",
 *             },
 *         },
 *         Subscriptions = new[] {},
 *         VirtualNetworks = new[]
 *         {
 *             new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *             {
 *                 Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA",
 *             },
 *             new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *             {
 *                 Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetwork.NewManagedNetworkGroup(ctx, "managedNetworkGroup", &managednetwork.ManagedNetworkGroupArgs{
 * 			ManagedNetworkGroupName: pulumi.String("myManagedNetworkGroup1"),
 * 			ManagedNetworkName:      pulumi.String("myManagedNetwork"),
 * 			ManagementGroups:        managednetwork.ResourceIdArray{},
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 			Subnets: []managednetwork.ResourceIdArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA/subnets/subnetA"),
 * 				},
 * 			},
 * 			Subscriptions: managednetwork.ResourceIdArray{},
 * 			VirtualNetworks: []managednetwork.ResourceIdArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
 * 				},
 * 				{
 * 					Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkGroup;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedNetworkGroup = new ManagedNetworkGroup("managedNetworkGroup", ManagedNetworkGroupArgs.builder()
 *             .managedNetworkGroupName("myManagedNetworkGroup1")
 *             .managedNetworkName("myManagedNetwork")
 *             .managementGroups()
 *             .resourceGroupName("myResourceGroup")
 *             .subnets(Map.of("id", "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA/subnets/subnetA"))
 *             .subscriptions()
 *             .virtualNetworks(
 *                 Map.of("id", "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
 *                 Map.of("id", "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetwork:ManagedNetworkGroup myManagedNetworkGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}/managedNetworkGroups/{managedNetworkGroupName}
 * ```
 */
public class ManagedNetworkGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetwork.ManagedNetworkGroup,
) : KotlinCustomResource(javaResource, ManagedNetworkGroupMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Responsibility role under which this Managed Network Group will be created
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The collection of management groups covered by the Managed Network
     */
    public val managementGroups: Output<List<ResourceIdResponse>>?
        get() = javaResource.managementGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the ManagedNetwork resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The collection of  subnets covered by the Managed Network
     */
    public val subnets: Output<List<ResourceIdResponse>>?
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The collection of subscriptions covered by the Managed Network
     */
    public val subscriptions: Output<List<ResourceIdResponse>>?
        get() = javaResource.subscriptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The collection of virtual nets covered by the Managed Network
     */
    public val virtualNetworks: Output<List<ResourceIdResponse>>?
        get() = javaResource.virtualNetworks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object ManagedNetworkGroupMapper : ResourceMapper<ManagedNetworkGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetwork.ManagedNetworkGroup::class == javaResource::class

    override fun map(javaResource: Resource): ManagedNetworkGroup = ManagedNetworkGroup(
        javaResource
            as com.pulumi.azurenative.managednetwork.ManagedNetworkGroup,
    )
}

/**
 * @see [ManagedNetworkGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedNetworkGroup].
 */
public suspend fun managedNetworkGroup(
    name: String,
    block: suspend ManagedNetworkGroupResourceBuilder.() -> Unit,
): ManagedNetworkGroup {
    val builder = ManagedNetworkGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedNetworkGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedNetworkGroup(name: String): ManagedNetworkGroup {
    val builder = ManagedNetworkGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
