@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ScopeAssignment].
 */
@PulumiTagMarker
public class ScopeAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScopeAssignmentArgs = ScopeAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScopeAssignmentArgsBuilder.() -> Unit) {
        val builder = ScopeAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScopeAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.managednetwork.ScopeAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScopeAssignment(builtJavaResource)
    }
}

/**
 * The Managed Network resource
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### ScopeAssignmentsPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopeAssignment = new AzureNative.ManagedNetwork.ScopeAssignment("scopeAssignment", new()
 *     {
 *         AssignedManagedNetwork = "/subscriptions/subscriptionA/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork",
 *         Scope = "subscriptions/subscriptionC",
 *         ScopeAssignmentName = "subscriptionCAssignment",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetwork.NewScopeAssignment(ctx, "scopeAssignment", &managednetwork.ScopeAssignmentArgs{
 * 			AssignedManagedNetwork: pulumi.String("/subscriptions/subscriptionA/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork"),
 * 			Scope:                  pulumi.String("subscriptions/subscriptionC"),
 * 			ScopeAssignmentName:    pulumi.String("subscriptionCAssignment"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetwork.ScopeAssignment;
 * import com.pulumi.azurenative.managednetwork.ScopeAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopeAssignment = new ScopeAssignment("scopeAssignment", ScopeAssignmentArgs.builder()
 *             .assignedManagedNetwork("/subscriptions/subscriptionA/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork")
 *             .scope("subscriptions/subscriptionC")
 *             .scopeAssignmentName("subscriptionCAssignment")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetwork:ScopeAssignment subscriptionCAssignment /{scope}/providers/Microsoft.ManagedNetwork/scopeAssignments/{scopeAssignmentName}
 * ```
 */
public class ScopeAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetwork.ScopeAssignment,
) : KotlinCustomResource(javaResource, ScopeAssignmentMapper) {
    /**
     * The managed network ID with scope will be assigned to.
     */
    public val assignedManagedNetwork: Output<String>?
        get() = javaResource.assignedManagedNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the ManagedNetwork resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScopeAssignmentMapper : ResourceMapper<ScopeAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetwork.ScopeAssignment::class == javaResource::class

    override fun map(javaResource: Resource): ScopeAssignment = ScopeAssignment(
        javaResource as
            com.pulumi.azurenative.managednetwork.ScopeAssignment,
    )
}

/**
 * @see [ScopeAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScopeAssignment].
 */
public suspend fun scopeAssignment(
    name: String,
    block: suspend ScopeAssignmentResourceBuilder.() -> Unit,
): ScopeAssignment {
    val builder = ScopeAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScopeAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scopeAssignment(name: String): ScopeAssignment {
    val builder = ScopeAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
