@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.inputs

import com.pulumi.azurenative.managednetwork.inputs.ScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Scope of a Managed Network
 * @property managementGroups The collection of management groups covered by the Managed Network
 * @property subnets The collection of  subnets covered by the Managed Network
 * @property subscriptions The collection of subscriptions covered by the Managed Network
 * @property virtualNetworks The collection of virtual nets covered by the Managed Network
 */
public data class ScopeArgs(
    public val managementGroups: Output<List<ResourceIdArgs>>? = null,
    public val subnets: Output<List<ResourceIdArgs>>? = null,
    public val subscriptions: Output<List<ResourceIdArgs>>? = null,
    public val virtualNetworks: Output<List<ResourceIdArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.inputs.ScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetwork.inputs.ScopeArgs =
        com.pulumi.azurenative.managednetwork.inputs.ScopeArgs.builder()
            .managementGroups(
                managementGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subscriptions(
                subscriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworks(
                virtualNetworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScopeArgs].
 */
@PulumiTagMarker
public class ScopeArgsBuilder internal constructor() {
    private var managementGroups: Output<List<ResourceIdArgs>>? = null

    private var subnets: Output<List<ResourceIdArgs>>? = null

    private var subscriptions: Output<List<ResourceIdArgs>>? = null

    private var virtualNetworks: Output<List<ResourceIdArgs>>? = null

    /**
     * @param value The collection of management groups covered by the Managed Network
     */
    @JvmName("lkxcbmprekkxbbhs")
    public suspend fun managementGroups(`value`: Output<List<ResourceIdArgs>>) {
        this.managementGroups = value
    }

    @JvmName("gpgdgcxkbvvkctqt")
    public suspend fun managementGroups(vararg values: Output<ResourceIdArgs>) {
        this.managementGroups = Output.all(values.asList())
    }

    /**
     * @param values The collection of management groups covered by the Managed Network
     */
    @JvmName("atxoyphguilqghim")
    public suspend fun managementGroups(values: List<Output<ResourceIdArgs>>) {
        this.managementGroups = Output.all(values)
    }

    /**
     * @param value The collection of  subnets covered by the Managed Network
     */
    @JvmName("vfbqhqxdywuegild")
    public suspend fun subnets(`value`: Output<List<ResourceIdArgs>>) {
        this.subnets = value
    }

    @JvmName("tgrjophjtyomawhp")
    public suspend fun subnets(vararg values: Output<ResourceIdArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The collection of  subnets covered by the Managed Network
     */
    @JvmName("vaobftuabtgafyea")
    public suspend fun subnets(values: List<Output<ResourceIdArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value The collection of subscriptions covered by the Managed Network
     */
    @JvmName("hfepogdogfjtswtb")
    public suspend fun subscriptions(`value`: Output<List<ResourceIdArgs>>) {
        this.subscriptions = value
    }

    @JvmName("ndyansdmajktkyof")
    public suspend fun subscriptions(vararg values: Output<ResourceIdArgs>) {
        this.subscriptions = Output.all(values.asList())
    }

    /**
     * @param values The collection of subscriptions covered by the Managed Network
     */
    @JvmName("mcwhfscibtkrhvre")
    public suspend fun subscriptions(values: List<Output<ResourceIdArgs>>) {
        this.subscriptions = Output.all(values)
    }

    /**
     * @param value The collection of virtual nets covered by the Managed Network
     */
    @JvmName("hmpqrkffoonteccn")
    public suspend fun virtualNetworks(`value`: Output<List<ResourceIdArgs>>) {
        this.virtualNetworks = value
    }

    @JvmName("xihfmrbwrmwqmohu")
    public suspend fun virtualNetworks(vararg values: Output<ResourceIdArgs>) {
        this.virtualNetworks = Output.all(values.asList())
    }

    /**
     * @param values The collection of virtual nets covered by the Managed Network
     */
    @JvmName("leieyjproslknvik")
    public suspend fun virtualNetworks(values: List<Output<ResourceIdArgs>>) {
        this.virtualNetworks = Output.all(values)
    }

    /**
     * @param value The collection of management groups covered by the Managed Network
     */
    @JvmName("gbniyxtskhcamtgt")
    public suspend fun managementGroups(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param argument The collection of management groups covered by the Managed Network
     */
    @JvmName("skloqpljpjofokid")
    public suspend fun managementGroups(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.managementGroups = mapped
    }

    /**
     * @param argument The collection of management groups covered by the Managed Network
     */
    @JvmName("jfiqnnidjlpuhbwy")
    public suspend fun managementGroups(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.managementGroups = mapped
    }

    /**
     * @param argument The collection of management groups covered by the Managed Network
     */
    @JvmName("uwttriwrmwuuqkfm")
    public suspend fun managementGroups(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.managementGroups = mapped
    }

    /**
     * @param values The collection of management groups covered by the Managed Network
     */
    @JvmName("nhahlwberyfxloim")
    public suspend fun managementGroups(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param value The collection of  subnets covered by the Managed Network
     */
    @JvmName("alnmnhkitrvbsdce")
    public suspend fun subnets(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument The collection of  subnets covered by the Managed Network
     */
    @JvmName("ggwfqhrwbnbxptnx")
    public suspend fun subnets(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The collection of  subnets covered by the Managed Network
     */
    @JvmName("vxatvrvhbdatjvil")
    public suspend fun subnets(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The collection of  subnets covered by the Managed Network
     */
    @JvmName("pcctpmvlvcmeuggc")
    public suspend fun subnets(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values The collection of  subnets covered by the Managed Network
     */
    @JvmName("jdgffyerywkcibsb")
    public suspend fun subnets(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value The collection of subscriptions covered by the Managed Network
     */
    @JvmName("ncrghhtbsgcycmge")
    public suspend fun subscriptions(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param argument The collection of subscriptions covered by the Managed Network
     */
    @JvmName("wrboqjefhntrwdao")
    public suspend fun subscriptions(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param argument The collection of subscriptions covered by the Managed Network
     */
    @JvmName("rtnwwxtbckecltvi")
    public suspend fun subscriptions(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param argument The collection of subscriptions covered by the Managed Network
     */
    @JvmName("agrtktgtnfwdgifi")
    public suspend fun subscriptions(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param values The collection of subscriptions covered by the Managed Network
     */
    @JvmName("kqnaagtwpdnelyig")
    public suspend fun subscriptions(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param value The collection of virtual nets covered by the Managed Network
     */
    @JvmName("gvdlhbrrgdpuwvku")
    public suspend fun virtualNetworks(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworks = mapped
    }

    /**
     * @param argument The collection of virtual nets covered by the Managed Network
     */
    @JvmName("jvjmdtlauylhjbmo")
    public suspend fun virtualNetworks(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.virtualNetworks = mapped
    }

    /**
     * @param argument The collection of virtual nets covered by the Managed Network
     */
    @JvmName("tlfrgkbailxshvux")
    public suspend fun virtualNetworks(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.virtualNetworks = mapped
    }

    /**
     * @param argument The collection of virtual nets covered by the Managed Network
     */
    @JvmName("lwlokavxftejgjjb")
    public suspend fun virtualNetworks(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworks = mapped
    }

    /**
     * @param values The collection of virtual nets covered by the Managed Network
     */
    @JvmName("sqjrcdwhteqvcrqy")
    public suspend fun virtualNetworks(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworks = mapped
    }

    internal fun build(): ScopeArgs = ScopeArgs(
        managementGroups = managementGroups,
        subnets = subnets,
        subscriptions = subscriptions,
        virtualNetworks = virtualNetworks,
    )
}
