@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The collection of Connectivity related groups and policies within the Managed Network
 * @property groups The collection of connectivity related Managed Network Groups within the Managed Network
 * @property peerings The collection of Managed Network Peering Policies within the Managed Network
 */
public data class ConnectivityCollectionResponse(
    public val groups: List<ManagedNetworkGroupResponse>,
    public val peerings: List<ManagedNetworkPeeringPolicyResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetwork.outputs.ConnectivityCollectionResponse):
            ConnectivityCollectionResponse = ConnectivityCollectionResponse(
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ManagedNetworkGroupResponse.Companion.toKotlin(args0)
                })
            }),
            peerings = javaType.peerings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ManagedNetworkPeeringPolicyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
