@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Managed Network Peering Policy resource
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property properties Gets or sets the properties of a Managed Network Policy
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class ManagedNetworkPeeringPolicyResponse(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: ManagedNetworkPeeringPolicyPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetwork.outputs.ManagedNetworkPeeringPolicyResponse):
            ManagedNetworkPeeringPolicyResponse = ManagedNetworkPeeringPolicyResponse(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ManagedNetworkPeeringPolicyPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
