@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.AccessControlListArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.AddressFamily
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.AccessControlListConditionPropertiesArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.AccessControlListConditionPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The AccessControlList resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### AccessControlLists_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessControlList = new AzureNative.ManagedNetworkFabric.AccessControlList("accessControlList", new()
 *     {
 *         AccessControlListName = "aclOne",
 *         AddressFamily = "ipv4",
 *         Conditions = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.AccessControlListConditionPropertiesArgs
 *             {
 *                 Action = "allow",
 *                 DestinationAddress = "1.1.1.1",
 *                 DestinationPort = "21",
 *                 Protocol = 6,
 *                 SequenceNumber = 3,
 *                 SourceAddress = "2.2.2.2",
 *                 SourcePort = "65000",
 *             },
 *         },
 *         Location = "EastUs",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewAccessControlList(ctx, "accessControlList", &managednetworkfabric.AccessControlListArgs{
 * 			AccessControlListName: pulumi.String("aclOne"),
 * 			AddressFamily:         pulumi.String("ipv4"),
 * 			Conditions: []managednetworkfabric.AccessControlListConditionPropertiesArgs{
 * 				{
 * 					Action:             pulumi.String("allow"),
 * 					DestinationAddress: pulumi.String("1.1.1.1"),
 * 					DestinationPort:    pulumi.String("21"),
 * 					Protocol:           pulumi.Int(6),
 * 					SequenceNumber:     pulumi.Int(3),
 * 					SourceAddress:      pulumi.String("2.2.2.2"),
 * 					SourcePort:         pulumi.String("65000"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("EastUs"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.AccessControlList;
 * import com.pulumi.azurenative.managednetworkfabric.AccessControlListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessControlList = new AccessControlList("accessControlList", AccessControlListArgs.builder()
 *             .accessControlListName("aclOne")
 *             .addressFamily("ipv4")
 *             .conditions(Map.ofEntries(
 *                 Map.entry("action", "allow"),
 *                 Map.entry("destinationAddress", "1.1.1.1"),
 *                 Map.entry("destinationPort", "21"),
 *                 Map.entry("protocol", 6),
 *                 Map.entry("sequenceNumber", 3),
 *                 Map.entry("sourceAddress", "2.2.2.2"),
 *                 Map.entry("sourcePort", "65000")
 *             ))
 *             .location("EastUs")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:AccessControlList aaaaaaaaaaaaaa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/accessControlLists/{accessControlListName}
 * ```
 * @property accessControlListName Name of the Access Control List
 * @property addressFamily IP address family. Example: ipv4 | ipv6.
 * @property annotation Switch configuration description.
 * @property conditions Access Control List conditions.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AccessControlListArgs(
    public val accessControlListName: Output<String>? = null,
    public val addressFamily: Output<Either<String, AddressFamily>>? = null,
    public val `annotation`: Output<String>? = null,
    public val conditions: Output<List<AccessControlListConditionPropertiesArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.AccessControlListArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.AccessControlListArgs =
        com.pulumi.azurenative.managednetworkfabric.AccessControlListArgs.builder()
            .accessControlListName(accessControlListName?.applyValue({ args0 -> args0 }))
            .addressFamily(
                addressFamily?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .conditions(
                conditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccessControlListArgs].
 */
@PulumiTagMarker
public class AccessControlListArgsBuilder internal constructor() {
    private var accessControlListName: Output<String>? = null

    private var addressFamily: Output<Either<String, AddressFamily>>? = null

    private var `annotation`: Output<String>? = null

    private var conditions: Output<List<AccessControlListConditionPropertiesArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Access Control List
     */
    @JvmName("aehwcksycrwtemqa")
    public suspend fun accessControlListName(`value`: Output<String>) {
        this.accessControlListName = value
    }

    /**
     * @param value IP address family. Example: ipv4 | ipv6.
     */
    @JvmName("alirgmireiyfdoqj")
    public suspend fun addressFamily(`value`: Output<Either<String, AddressFamily>>) {
        this.addressFamily = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("fjcgxbelxqdnvkmx")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Access Control List conditions.
     */
    @JvmName("svhgbmhigbjdekcw")
    public suspend fun conditions(`value`: Output<List<AccessControlListConditionPropertiesArgs>>) {
        this.conditions = value
    }

    @JvmName("dacepbmhefybnvaw")
    public suspend fun conditions(vararg values: Output<AccessControlListConditionPropertiesArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values Access Control List conditions.
     */
    @JvmName("xhsuiackayvfqhgo")
    public suspend fun conditions(values: List<Output<AccessControlListConditionPropertiesArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kpjlehslliagmbyh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lxhryemxjjcuimqk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bfuxwxhieuerskmh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Access Control List
     */
    @JvmName("lrlhfaexgbxdaxrt")
    public suspend fun accessControlListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlListName = mapped
    }

    /**
     * @param value IP address family. Example: ipv4 | ipv6.
     */
    @JvmName("rpogcwtricybompr")
    public suspend fun addressFamily(`value`: Either<String, AddressFamily>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value IP address family. Example: ipv4 | ipv6.
     */
    @JvmName("xsvtedqinowedyls")
    public fun addressFamily(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AddressFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value IP address family. Example: ipv4 | ipv6.
     */
    @JvmName("lmdnafxsfvyjdnnb")
    public fun addressFamily(`value`: AddressFamily) {
        val toBeMapped = Either.ofRight<String, AddressFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("iinqbfqdsojtieuj")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Access Control List conditions.
     */
    @JvmName("gclfylfbpdwgvjhp")
    public suspend fun conditions(`value`: List<AccessControlListConditionPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument Access Control List conditions.
     */
    @JvmName("caohosmshvqhmndc")
    public suspend
    fun conditions(argument: List<suspend AccessControlListConditionPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessControlListConditionPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Access Control List conditions.
     */
    @JvmName("jvoegddsforqoqui")
    public suspend fun conditions(
        vararg
        argument: suspend AccessControlListConditionPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessControlListConditionPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Access Control List conditions.
     */
    @JvmName("opdfiljjtdftlnix")
    public suspend
    fun conditions(argument: suspend AccessControlListConditionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AccessControlListConditionPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values Access Control List conditions.
     */
    @JvmName("dvskjuppuuganhlp")
    public suspend fun conditions(vararg values: AccessControlListConditionPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iiaywnfpwhjtxala")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ucklwtwqxmrvlvwb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tisayebqspyrkxxh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qvcyuhsteshgnhtv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccessControlListArgs = AccessControlListArgs(
        accessControlListName = accessControlListName,
        addressFamily = addressFamily,
        `annotation` = `annotation`,
        conditions = conditions,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
