@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.IpPrefixPropertiesIpPrefixRulesArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.IpPrefixPropertiesIpPrefixRulesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The IPPrefix resource definition.
 * Azure REST API version: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### IpPrefixes_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipPrefix = new AzureNative.ManagedNetworkFabric.IpPrefix("ipPrefix", new()
 *     {
 *         Annotation = "annotationValue",
 *         IpPrefixName = "example-ipPrefix",
 *         IpPrefixRules = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.IpPrefixPropertiesIpPrefixRulesArgs
 *             {
 *                 Action = "Permit",
 *                 Condition = "EqualTo",
 *                 NetworkPrefix = "1.1.1.0/24",
 *                 SequenceNumber = 12,
 *                 SubnetMaskLength = 28,
 *             },
 *         },
 *         Location = "EastUS",
 *         ResourceGroupName = "resourcegroupname",
 *         Tags =
 *         {
 *             { "key6404", "" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewIpPrefix(ctx, "ipPrefix", &managednetworkfabric.IpPrefixArgs{
 * 			Annotation:   pulumi.String("annotationValue"),
 * 			IpPrefixName: pulumi.String("example-ipPrefix"),
 * 			IpPrefixRules: []managednetworkfabric.IpPrefixPropertiesIpPrefixRulesArgs{
 * 				{
 * 					Action:           pulumi.String("Permit"),
 * 					Condition:        pulumi.String("EqualTo"),
 * 					NetworkPrefix:    pulumi.String("1.1.1.0/24"),
 * 					SequenceNumber:   pulumi.Float64(12),
 * 					SubnetMaskLength: pulumi.Int(28),
 * 				},
 * 			},
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 			Tags: pulumi.StringMap{
 * 				"key6404": pulumi.String(""),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.IpPrefix;
 * import com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipPrefix = new IpPrefix("ipPrefix", IpPrefixArgs.builder()
 *             .annotation("annotationValue")
 *             .ipPrefixName("example-ipPrefix")
 *             .ipPrefixRules(Map.ofEntries(
 *                 Map.entry("action", "Permit"),
 *                 Map.entry("condition", "EqualTo"),
 *                 Map.entry("networkPrefix", "1.1.1.0/24"),
 *                 Map.entry("sequenceNumber", 12),
 *                 Map.entry("subnetMaskLength", 28)
 *             ))
 *             .location("EastUS")
 *             .resourceGroupName("resourcegroupname")
 *             .tags(Map.of("key6404", ""))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:IpPrefix example-ipPrefix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/{ipPrefixName}
 * ```
 * @property annotation Switch configuration description.
 * @property ipPrefixName Name of the IP Prefix
 * @property ipPrefixRules IpPrefix contains the list of IP PrefixRules objects.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class IpPrefixArgs(
    public val `annotation`: Output<String>? = null,
    public val ipPrefixName: Output<String>? = null,
    public val ipPrefixRules: Output<List<IpPrefixPropertiesIpPrefixRulesArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs =
        com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .ipPrefixName(ipPrefixName?.applyValue({ args0 -> args0 }))
            .ipPrefixRules(
                ipPrefixRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IpPrefixArgs].
 */
@PulumiTagMarker
public class IpPrefixArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var ipPrefixName: Output<String>? = null

    private var ipPrefixRules: Output<List<IpPrefixPropertiesIpPrefixRulesArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("kwovmutsqpthyfdv")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Name of the IP Prefix
     */
    @JvmName("iksddwkattnduxyb")
    public suspend fun ipPrefixName(`value`: Output<String>) {
        this.ipPrefixName = value
    }

    /**
     * @param value IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("cuxpkwyjvolcgfce")
    public suspend fun ipPrefixRules(`value`: Output<List<IpPrefixPropertiesIpPrefixRulesArgs>>) {
        this.ipPrefixRules = value
    }

    @JvmName("cqexubwgbwniekkg")
    public suspend fun ipPrefixRules(vararg values: Output<IpPrefixPropertiesIpPrefixRulesArgs>) {
        this.ipPrefixRules = Output.all(values.asList())
    }

    /**
     * @param values IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("aeuskfnfnvfqnrkb")
    public suspend fun ipPrefixRules(values: List<Output<IpPrefixPropertiesIpPrefixRulesArgs>>) {
        this.ipPrefixRules = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dfnwnuegvupyqtdf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gdurdjxvrrppdxju")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ohyrqxbspdkgxiim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("cndrmnfieerpsjgp")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Name of the IP Prefix
     */
    @JvmName("lkfplvjvlrwnmtyx")
    public suspend fun ipPrefixName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPrefixName = mapped
    }

    /**
     * @param value IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("fmvkbevscwvbange")
    public suspend fun ipPrefixRules(`value`: List<IpPrefixPropertiesIpPrefixRulesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPrefixRules = mapped
    }

    /**
     * @param argument IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("qrdngrgskbdupmok")
    public suspend
    fun ipPrefixRules(argument: List<suspend IpPrefixPropertiesIpPrefixRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpPrefixPropertiesIpPrefixRulesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipPrefixRules = mapped
    }

    /**
     * @param argument IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("ihiqvxeuueybwkqr")
    public suspend fun ipPrefixRules(
        vararg
        argument: suspend IpPrefixPropertiesIpPrefixRulesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IpPrefixPropertiesIpPrefixRulesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipPrefixRules = mapped
    }

    /**
     * @param argument IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("spmdjlfeiblylyhu")
    public suspend
    fun ipPrefixRules(argument: suspend IpPrefixPropertiesIpPrefixRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IpPrefixPropertiesIpPrefixRulesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipPrefixRules = mapped
    }

    /**
     * @param values IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("wnnnlmusnahpsvoj")
    public suspend fun ipPrefixRules(vararg values: IpPrefixPropertiesIpPrefixRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipPrefixRules = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hssuktkfenndpouq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hbcoqforgmgheojo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("klpnaynoggfqqldc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("avjgogfvrsyhkifc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IpPrefixArgs = IpPrefixArgs(
        `annotation` = `annotation`,
        ipPrefixName = ipPrefixName,
        ipPrefixRules = ipPrefixRules,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
