@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getAccessControlListPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getExternalNetworkPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getInternalNetworkPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getInternetGatewayPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getInternetGatewayRulePlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getIpCommunityPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getIpExtendedCommunityPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getIpPrefixPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getL2IsolationDomainPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getL3IsolationDomainPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNeighborGroupPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkDevicePlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkDeviceStatusPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkFabricControllerPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkFabricPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkFabricTopologyPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkInterfacePlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkInterfaceStatusPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkPacketBrokerPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkRackPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkTapPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkTapRulePlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getNetworkToNetworkInterconnectPlain
import com.pulumi.azurenative.managednetworkfabric.ManagednetworkfabricFunctions.getRoutePolicyPlain
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetAccessControlListPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetAccessControlListPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetExternalNetworkPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetExternalNetworkPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetInternalNetworkPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetInternalNetworkPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetInternetGatewayPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetInternetGatewayPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetInternetGatewayRulePlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetInternetGatewayRulePlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetIpCommunityPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetIpCommunityPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetIpExtendedCommunityPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetIpExtendedCommunityPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetIpPrefixPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetIpPrefixPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetL2IsolationDomainPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetL2IsolationDomainPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetL3IsolationDomainPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetL3IsolationDomainPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNeighborGroupPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNeighborGroupPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkDevicePlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkDevicePlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkDeviceStatusPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkDeviceStatusPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkFabricControllerPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkFabricControllerPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkFabricPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkFabricPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkFabricTopologyPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkFabricTopologyPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkInterfacePlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkInterfacePlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkInterfaceStatusPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkInterfaceStatusPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkPacketBrokerPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkPacketBrokerPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkRackPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkRackPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkTapPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkTapPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkTapRulePlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkTapRulePlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkToNetworkInterconnectPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetNetworkToNetworkInterconnectPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetRoutePolicyPlainArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.GetRoutePolicyPlainArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetAccessControlListResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetExternalNetworkResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetInternalNetworkResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetInternetGatewayResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetInternetGatewayRuleResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetIpCommunityResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetIpExtendedCommunityResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetIpPrefixResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetL2IsolationDomainResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetL3IsolationDomainResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNeighborGroupResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkDeviceResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkDeviceStatusResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkFabricControllerResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkFabricResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkFabricTopologyResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkInterfaceResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkInterfaceStatusResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkPacketBrokerResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkRackResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkTapResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkTapRuleResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkToNetworkInterconnectResult
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetRoutePolicyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetAccessControlListResult.Companion.toKotlin as getAccessControlListResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetExternalNetworkResult.Companion.toKotlin as getExternalNetworkResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetInternalNetworkResult.Companion.toKotlin as getInternalNetworkResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetInternetGatewayResult.Companion.toKotlin as getInternetGatewayResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetInternetGatewayRuleResult.Companion.toKotlin as getInternetGatewayRuleResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetIpCommunityResult.Companion.toKotlin as getIpCommunityResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetIpExtendedCommunityResult.Companion.toKotlin as getIpExtendedCommunityResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetIpPrefixResult.Companion.toKotlin as getIpPrefixResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetL2IsolationDomainResult.Companion.toKotlin as getL2IsolationDomainResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetL3IsolationDomainResult.Companion.toKotlin as getL3IsolationDomainResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNeighborGroupResult.Companion.toKotlin as getNeighborGroupResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkDeviceResult.Companion.toKotlin as getNetworkDeviceResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkDeviceStatusResult.Companion.toKotlin as getNetworkDeviceStatusResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkFabricControllerResult.Companion.toKotlin as getNetworkFabricControllerResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkFabricResult.Companion.toKotlin as getNetworkFabricResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkFabricTopologyResult.Companion.toKotlin as getNetworkFabricTopologyResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkInterfaceResult.Companion.toKotlin as getNetworkInterfaceResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkInterfaceStatusResult.Companion.toKotlin as getNetworkInterfaceStatusResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkPacketBrokerResult.Companion.toKotlin as getNetworkPacketBrokerResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkRackResult.Companion.toKotlin as getNetworkRackResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkTapResult.Companion.toKotlin as getNetworkTapResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkTapRuleResult.Companion.toKotlin as getNetworkTapRuleResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetNetworkToNetworkInterconnectResult.Companion.toKotlin as getNetworkToNetworkInterconnectResultToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.GetRoutePolicyResult.Companion.toKotlin as getRoutePolicyResultToKotlin

public object ManagednetworkfabricFunctions {
    /**
     * Implements Access Control List GET method.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The AccessControlList resource definition.
     */
    public suspend fun getAccessControlList(argument: GetAccessControlListPlainArgs):
        GetAccessControlListResult =
        getAccessControlListResultToKotlin(getAccessControlListPlain(argument.toJava()).await())

    /**
     * @see [getAccessControlList].
     * @param accessControlListName Name of the Access Control List
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The AccessControlList resource definition.
     */
    public suspend fun getAccessControlList(accessControlListName: String, resourceGroupName: String):
        GetAccessControlListResult {
        val argument = GetAccessControlListPlainArgs(
            accessControlListName = accessControlListName,
            resourceGroupName = resourceGroupName,
        )
        return getAccessControlListResultToKotlin(getAccessControlListPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessControlList].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetAccessControlListPlainArgs].
     * @return The AccessControlList resource definition.
     */
    public suspend
    fun getAccessControlList(argument: suspend GetAccessControlListPlainArgsBuilder.() -> Unit):
        GetAccessControlListResult {
        val builder = GetAccessControlListPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessControlListResultToKotlin(getAccessControlListPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements ExternalNetworks GET method.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return Defines the ExternalNetwork item.
     */
    public suspend fun getExternalNetwork(argument: GetExternalNetworkPlainArgs):
        GetExternalNetworkResult =
        getExternalNetworkResultToKotlin(getExternalNetworkPlain(argument.toJava()).await())

    /**
     * @see [getExternalNetwork].
     * @param externalNetworkName Name of the ExternalNetwork
     * @param l3IsolationDomainName Name of the L3IsolationDomain
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Defines the ExternalNetwork item.
     */
    public suspend fun getExternalNetwork(
        externalNetworkName: String,
        l3IsolationDomainName: String,
        resourceGroupName: String,
    ): GetExternalNetworkResult {
        val argument = GetExternalNetworkPlainArgs(
            externalNetworkName = externalNetworkName,
            l3IsolationDomainName = l3IsolationDomainName,
            resourceGroupName = resourceGroupName,
        )
        return getExternalNetworkResultToKotlin(getExternalNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getExternalNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetExternalNetworkPlainArgs].
     * @return Defines the ExternalNetwork item.
     */
    public suspend
    fun getExternalNetwork(argument: suspend GetExternalNetworkPlainArgsBuilder.() -> Unit):
        GetExternalNetworkResult {
        val builder = GetExternalNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExternalNetworkResultToKotlin(getExternalNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a InternalNetworks.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return Defines the InternalNetwork item.
     */
    public suspend fun getInternalNetwork(argument: GetInternalNetworkPlainArgs):
        GetInternalNetworkResult =
        getInternalNetworkResultToKotlin(getInternalNetworkPlain(argument.toJava()).await())

    /**
     * @see [getInternalNetwork].
     * @param internalNetworkName Name of the InternalNetwork
     * @param l3IsolationDomainName Name of the L3IsolationDomain
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Defines the InternalNetwork item.
     */
    public suspend fun getInternalNetwork(
        internalNetworkName: String,
        l3IsolationDomainName: String,
        resourceGroupName: String,
    ): GetInternalNetworkResult {
        val argument = GetInternalNetworkPlainArgs(
            internalNetworkName = internalNetworkName,
            l3IsolationDomainName = l3IsolationDomainName,
            resourceGroupName = resourceGroupName,
        )
        return getInternalNetworkResultToKotlin(getInternalNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getInternalNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetInternalNetworkPlainArgs].
     * @return Defines the InternalNetwork item.
     */
    public suspend
    fun getInternalNetwork(argument: suspend GetInternalNetworkPlainArgsBuilder.() -> Unit):
        GetInternalNetworkResult {
        val builder = GetInternalNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInternalNetworkResultToKotlin(getInternalNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements Gateway GET method.
     * Azure REST API version: 2023-06-15.
     * @param argument null
     * @return The Internet Gateway resource definition.
     */
    public suspend fun getInternetGateway(argument: GetInternetGatewayPlainArgs):
        GetInternetGatewayResult =
        getInternetGatewayResultToKotlin(getInternetGatewayPlain(argument.toJava()).await())

    /**
     * @see [getInternetGateway].
     * @param internetGatewayName Name of the Internet Gateway.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Internet Gateway resource definition.
     */
    public suspend fun getInternetGateway(internetGatewayName: String, resourceGroupName: String):
        GetInternetGatewayResult {
        val argument = GetInternetGatewayPlainArgs(
            internetGatewayName = internetGatewayName,
            resourceGroupName = resourceGroupName,
        )
        return getInternetGatewayResultToKotlin(getInternetGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getInternetGateway].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetInternetGatewayPlainArgs].
     * @return The Internet Gateway resource definition.
     */
    public suspend
    fun getInternetGateway(argument: suspend GetInternetGatewayPlainArgsBuilder.() -> Unit):
        GetInternetGatewayResult {
        val builder = GetInternetGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInternetGatewayResultToKotlin(getInternetGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an Internet Gateway Rule resource.
     * Azure REST API version: 2023-06-15.
     * @param argument null
     * @return The Internet Gateway Rule resource definition.
     */
    public suspend fun getInternetGatewayRule(argument: GetInternetGatewayRulePlainArgs):
        GetInternetGatewayRuleResult =
        getInternetGatewayRuleResultToKotlin(getInternetGatewayRulePlain(argument.toJava()).await())

    /**
     * @see [getInternetGatewayRule].
     * @param internetGatewayRuleName Name of the Internet Gateway rule.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Internet Gateway Rule resource definition.
     */
    public suspend fun getInternetGatewayRule(
        internetGatewayRuleName: String,
        resourceGroupName: String,
    ): GetInternetGatewayRuleResult {
        val argument = GetInternetGatewayRulePlainArgs(
            internetGatewayRuleName = internetGatewayRuleName,
            resourceGroupName = resourceGroupName,
        )
        return getInternetGatewayRuleResultToKotlin(getInternetGatewayRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getInternetGatewayRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetInternetGatewayRulePlainArgs].
     * @return The Internet Gateway Rule resource definition.
     */
    public suspend
    fun getInternetGatewayRule(argument: suspend GetInternetGatewayRulePlainArgsBuilder.() -> Unit):
        GetInternetGatewayRuleResult {
        val builder = GetInternetGatewayRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInternetGatewayRuleResultToKotlin(getInternetGatewayRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Implements an IP Community GET method.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The IpCommunity resource definition.
     */
    public suspend fun getIpCommunity(argument: GetIpCommunityPlainArgs): GetIpCommunityResult =
        getIpCommunityResultToKotlin(getIpCommunityPlain(argument.toJava()).await())

    /**
     * @see [getIpCommunity].
     * @param ipCommunityName Name of the IP Community.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The IpCommunity resource definition.
     */
    public suspend fun getIpCommunity(ipCommunityName: String, resourceGroupName: String):
        GetIpCommunityResult {
        val argument = GetIpCommunityPlainArgs(
            ipCommunityName = ipCommunityName,
            resourceGroupName = resourceGroupName,
        )
        return getIpCommunityResultToKotlin(getIpCommunityPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpCommunity].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetIpCommunityPlainArgs].
     * @return The IpCommunity resource definition.
     */
    public suspend fun getIpCommunity(argument: suspend GetIpCommunityPlainArgsBuilder.() -> Unit):
        GetIpCommunityResult {
        val builder = GetIpCommunityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpCommunityResultToKotlin(getIpCommunityPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements IP Extended Community GET method.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The IpExtendedCommunity resource definition.
     */
    public suspend fun getIpExtendedCommunity(argument: GetIpExtendedCommunityPlainArgs):
        GetIpExtendedCommunityResult =
        getIpExtendedCommunityResultToKotlin(getIpExtendedCommunityPlain(argument.toJava()).await())

    /**
     * @see [getIpExtendedCommunity].
     * @param ipExtendedCommunityName Name of the IP Extended Community
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The IpExtendedCommunity resource definition.
     */
    public suspend fun getIpExtendedCommunity(
        ipExtendedCommunityName: String,
        resourceGroupName: String,
    ): GetIpExtendedCommunityResult {
        val argument = GetIpExtendedCommunityPlainArgs(
            ipExtendedCommunityName = ipExtendedCommunityName,
            resourceGroupName = resourceGroupName,
        )
        return getIpExtendedCommunityResultToKotlin(getIpExtendedCommunityPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpExtendedCommunity].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetIpExtendedCommunityPlainArgs].
     * @return The IpExtendedCommunity resource definition.
     */
    public suspend
    fun getIpExtendedCommunity(argument: suspend GetIpExtendedCommunityPlainArgsBuilder.() -> Unit):
        GetIpExtendedCommunityResult {
        val builder = GetIpExtendedCommunityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpExtendedCommunityResultToKotlin(getIpExtendedCommunityPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements IP Prefix GET method.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The IPPrefix resource definition.
     */
    public suspend fun getIpPrefix(argument: GetIpPrefixPlainArgs): GetIpPrefixResult =
        getIpPrefixResultToKotlin(getIpPrefixPlain(argument.toJava()).await())

    /**
     * @see [getIpPrefix].
     * @param ipPrefixName Name of the IP Prefix
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The IPPrefix resource definition.
     */
    public suspend fun getIpPrefix(ipPrefixName: String, resourceGroupName: String):
        GetIpPrefixResult {
        val argument = GetIpPrefixPlainArgs(
            ipPrefixName = ipPrefixName,
            resourceGroupName = resourceGroupName,
        )
        return getIpPrefixResultToKotlin(getIpPrefixPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpPrefix].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetIpPrefixPlainArgs].
     * @return The IPPrefix resource definition.
     */
    public suspend fun getIpPrefix(argument: suspend GetIpPrefixPlainArgsBuilder.() -> Unit):
        GetIpPrefixResult {
        val builder = GetIpPrefixPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpPrefixResultToKotlin(getIpPrefixPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements L2 Isolation Domain GET method.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The L2IsolationDomain resource definition.
     */
    public suspend fun getL2IsolationDomain(argument: GetL2IsolationDomainPlainArgs):
        GetL2IsolationDomainResult =
        getL2IsolationDomainResultToKotlin(getL2IsolationDomainPlain(argument.toJava()).await())

    /**
     * @see [getL2IsolationDomain].
     * @param l2IsolationDomainName Name of the L2 Isolation Domain
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The L2IsolationDomain resource definition.
     */
    public suspend fun getL2IsolationDomain(l2IsolationDomainName: String, resourceGroupName: String):
        GetL2IsolationDomainResult {
        val argument = GetL2IsolationDomainPlainArgs(
            l2IsolationDomainName = l2IsolationDomainName,
            resourceGroupName = resourceGroupName,
        )
        return getL2IsolationDomainResultToKotlin(getL2IsolationDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getL2IsolationDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetL2IsolationDomainPlainArgs].
     * @return The L2IsolationDomain resource definition.
     */
    public suspend
    fun getL2IsolationDomain(argument: suspend GetL2IsolationDomainPlainArgsBuilder.() -> Unit):
        GetL2IsolationDomainResult {
        val builder = GetL2IsolationDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getL2IsolationDomainResultToKotlin(getL2IsolationDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves details of this L3 Isolation Domain.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The L3IsolationDomain resource definition.
     */
    public suspend fun getL3IsolationDomain(argument: GetL3IsolationDomainPlainArgs):
        GetL3IsolationDomainResult =
        getL3IsolationDomainResultToKotlin(getL3IsolationDomainPlain(argument.toJava()).await())

    /**
     * @see [getL3IsolationDomain].
     * @param l3IsolationDomainName Name of the L3 Isolation Domain
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The L3IsolationDomain resource definition.
     */
    public suspend fun getL3IsolationDomain(l3IsolationDomainName: String, resourceGroupName: String):
        GetL3IsolationDomainResult {
        val argument = GetL3IsolationDomainPlainArgs(
            l3IsolationDomainName = l3IsolationDomainName,
            resourceGroupName = resourceGroupName,
        )
        return getL3IsolationDomainResultToKotlin(getL3IsolationDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getL3IsolationDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetL3IsolationDomainPlainArgs].
     * @return The L3IsolationDomain resource definition.
     */
    public suspend
    fun getL3IsolationDomain(argument: suspend GetL3IsolationDomainPlainArgsBuilder.() -> Unit):
        GetL3IsolationDomainResult {
        val builder = GetL3IsolationDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getL3IsolationDomainResultToKotlin(getL3IsolationDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Neighbor Group.
     * Azure REST API version: 2023-06-15.
     * @param argument null
     * @return Defines the Neighbor Group.
     */
    public suspend fun getNeighborGroup(argument: GetNeighborGroupPlainArgs): GetNeighborGroupResult =
        getNeighborGroupResultToKotlin(getNeighborGroupPlain(argument.toJava()).await())

    /**
     * @see [getNeighborGroup].
     * @param neighborGroupName Name of the Neighbor Group.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Defines the Neighbor Group.
     */
    public suspend fun getNeighborGroup(neighborGroupName: String, resourceGroupName: String):
        GetNeighborGroupResult {
        val argument = GetNeighborGroupPlainArgs(
            neighborGroupName = neighborGroupName,
            resourceGroupName = resourceGroupName,
        )
        return getNeighborGroupResultToKotlin(getNeighborGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getNeighborGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNeighborGroupPlainArgs].
     * @return Defines the Neighbor Group.
     */
    public suspend
    fun getNeighborGroup(argument: suspend GetNeighborGroupPlainArgsBuilder.() -> Unit):
        GetNeighborGroupResult {
        val builder = GetNeighborGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNeighborGroupResultToKotlin(getNeighborGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Network Device resource details.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The NetworkDevice resource definition.
     */
    public suspend fun getNetworkDevice(argument: GetNetworkDevicePlainArgs): GetNetworkDeviceResult =
        getNetworkDeviceResultToKotlin(getNetworkDevicePlain(argument.toJava()).await())

    /**
     * @see [getNetworkDevice].
     * @param networkDeviceName Name of the Network Device
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The NetworkDevice resource definition.
     */
    public suspend fun getNetworkDevice(networkDeviceName: String, resourceGroupName: String):
        GetNetworkDeviceResult {
        val argument = GetNetworkDevicePlainArgs(
            networkDeviceName = networkDeviceName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkDeviceResultToKotlin(getNetworkDevicePlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkDevice].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkDevicePlainArgs].
     * @return The NetworkDevice resource definition.
     */
    public suspend
    fun getNetworkDevice(argument: suspend GetNetworkDevicePlainArgsBuilder.() -> Unit):
        GetNetworkDeviceResult {
        val builder = GetNetworkDevicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkDeviceResultToKotlin(getNetworkDevicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the running status of the Network Device.
     * Azure REST API version: 2023-02-01-preview.
     * @param argument null
     * @return Get Device status response properties.
     */
    public suspend fun getNetworkDeviceStatus(argument: GetNetworkDeviceStatusPlainArgs):
        GetNetworkDeviceStatusResult =
        getNetworkDeviceStatusResultToKotlin(getNetworkDeviceStatusPlain(argument.toJava()).await())

    /**
     * @see [getNetworkDeviceStatus].
     * @param networkDeviceName Name of the NetworkDevice.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Get Device status response properties.
     */
    public suspend fun getNetworkDeviceStatus(networkDeviceName: String, resourceGroupName: String):
        GetNetworkDeviceStatusResult {
        val argument = GetNetworkDeviceStatusPlainArgs(
            networkDeviceName = networkDeviceName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkDeviceStatusResultToKotlin(getNetworkDeviceStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkDeviceStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkDeviceStatusPlainArgs].
     * @return Get Device status response properties.
     */
    public suspend
    fun getNetworkDeviceStatus(argument: suspend GetNetworkDeviceStatusPlainArgsBuilder.() -> Unit):
        GetNetworkDeviceStatusResult {
        val builder = GetNetworkDeviceStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkDeviceStatusResultToKotlin(getNetworkDeviceStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Network Fabric resource details.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The NetworkFabric resource definition.
     */
    public suspend fun getNetworkFabric(argument: GetNetworkFabricPlainArgs): GetNetworkFabricResult =
        getNetworkFabricResultToKotlin(getNetworkFabricPlain(argument.toJava()).await())

    /**
     * @see [getNetworkFabric].
     * @param networkFabricName Name of the Network Fabric
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The NetworkFabric resource definition.
     */
    public suspend fun getNetworkFabric(networkFabricName: String, resourceGroupName: String):
        GetNetworkFabricResult {
        val argument = GetNetworkFabricPlainArgs(
            networkFabricName = networkFabricName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkFabricResultToKotlin(getNetworkFabricPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkFabric].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkFabricPlainArgs].
     * @return The NetworkFabric resource definition.
     */
    public suspend
    fun getNetworkFabric(argument: suspend GetNetworkFabricPlainArgsBuilder.() -> Unit):
        GetNetworkFabricResult {
        val builder = GetNetworkFabricPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkFabricResultToKotlin(getNetworkFabricPlain(builtArgument.toJava()).await())
    }

    /**
     * Shows the provisioning status of Network Fabric Controller.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The NetworkFabricController resource definition.
     */
    public suspend fun getNetworkFabricController(argument: GetNetworkFabricControllerPlainArgs):
        GetNetworkFabricControllerResult =
        getNetworkFabricControllerResultToKotlin(getNetworkFabricControllerPlain(argument.toJava()).await())

    /**
     * @see [getNetworkFabricController].
     * @param networkFabricControllerName Name of the Network Fabric Controller
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The NetworkFabricController resource definition.
     */
    public suspend fun getNetworkFabricController(
        networkFabricControllerName: String,
        resourceGroupName: String,
    ): GetNetworkFabricControllerResult {
        val argument = GetNetworkFabricControllerPlainArgs(
            networkFabricControllerName = networkFabricControllerName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkFabricControllerResultToKotlin(getNetworkFabricControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkFabricController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkFabricControllerPlainArgs].
     * @return The NetworkFabricController resource definition.
     */
    public suspend
    fun getNetworkFabricController(argument: suspend GetNetworkFabricControllerPlainArgsBuilder.() -> Unit):
        GetNetworkFabricControllerResult {
        val builder = GetNetworkFabricControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkFabricControllerResultToKotlin(getNetworkFabricControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets Topology of the underlying resources in the given Network Fabric instance.
     * Azure REST API version: 2023-06-15.
     * @param argument null
     * @return The response of the action validate configuration.
     */
    public suspend fun getNetworkFabricTopology(argument: GetNetworkFabricTopologyPlainArgs):
        GetNetworkFabricTopologyResult =
        getNetworkFabricTopologyResultToKotlin(getNetworkFabricTopologyPlain(argument.toJava()).await())

    /**
     * @see [getNetworkFabricTopology].
     * @param networkFabricName Name of the Network Fabric.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The response of the action validate configuration.
     */
    public suspend fun getNetworkFabricTopology(networkFabricName: String, resourceGroupName: String):
        GetNetworkFabricTopologyResult {
        val argument = GetNetworkFabricTopologyPlainArgs(
            networkFabricName = networkFabricName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkFabricTopologyResultToKotlin(getNetworkFabricTopologyPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkFabricTopology].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkFabricTopologyPlainArgs].
     * @return The response of the action validate configuration.
     */
    public suspend
    fun getNetworkFabricTopology(argument: suspend GetNetworkFabricTopologyPlainArgsBuilder.() -> Unit):
        GetNetworkFabricTopologyResult {
        val builder = GetNetworkFabricTopologyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkFabricTopologyResultToKotlin(getNetworkFabricTopologyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Network Interface resource details.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return Defines the NetworkInterface resource.
     */
    public suspend fun getNetworkInterface(argument: GetNetworkInterfacePlainArgs):
        GetNetworkInterfaceResult =
        getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(argument.toJava()).await())

    /**
     * @see [getNetworkInterface].
     * @param networkDeviceName Name of the NetworkDevice
     * @param networkInterfaceName Name of the NetworkInterfaceName
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Defines the NetworkInterface resource.
     */
    public suspend fun getNetworkInterface(
        networkDeviceName: String,
        networkInterfaceName: String,
        resourceGroupName: String,
    ): GetNetworkInterfaceResult {
        val argument = GetNetworkInterfacePlainArgs(
            networkDeviceName = networkDeviceName,
            networkInterfaceName = networkInterfaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInterface].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkInterfacePlainArgs].
     * @return Defines the NetworkInterface resource.
     */
    public suspend
    fun getNetworkInterface(argument: suspend GetNetworkInterfacePlainArgsBuilder.() -> Unit):
        GetNetworkInterfaceResult {
        val builder = GetNetworkInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the running status of the Network Interface.
     * Azure REST API version: 2023-02-01-preview.
     * @param argument null
     * @return Interface running status properties
     */
    public suspend fun getNetworkInterfaceStatus(argument: GetNetworkInterfaceStatusPlainArgs):
        GetNetworkInterfaceStatusResult =
        getNetworkInterfaceStatusResultToKotlin(getNetworkInterfaceStatusPlain(argument.toJava()).await())

    /**
     * @see [getNetworkInterfaceStatus].
     * @param networkDeviceName Name of the NetworkDevice.
     * @param networkInterfaceName Name of the NetworkInterface
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Interface running status properties
     */
    public suspend fun getNetworkInterfaceStatus(
        networkDeviceName: String,
        networkInterfaceName: String,
        resourceGroupName: String,
    ): GetNetworkInterfaceStatusResult {
        val argument = GetNetworkInterfaceStatusPlainArgs(
            networkDeviceName = networkDeviceName,
            networkInterfaceName = networkInterfaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkInterfaceStatusResultToKotlin(getNetworkInterfaceStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInterfaceStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkInterfaceStatusPlainArgs].
     * @return Interface running status properties
     */
    public suspend
    fun getNetworkInterfaceStatus(argument: suspend GetNetworkInterfaceStatusPlainArgsBuilder.() -> Unit):
        GetNetworkInterfaceStatusResult {
        val builder = GetNetworkInterfaceStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInterfaceStatusResultToKotlin(getNetworkInterfaceStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves details of this Network Packet Broker.
     * Azure REST API version: 2023-06-15.
     * @param argument null
     * @return The NetworkPacketBroker resource definition.
     */
    public suspend fun getNetworkPacketBroker(argument: GetNetworkPacketBrokerPlainArgs):
        GetNetworkPacketBrokerResult =
        getNetworkPacketBrokerResultToKotlin(getNetworkPacketBrokerPlain(argument.toJava()).await())

    /**
     * @see [getNetworkPacketBroker].
     * @param networkPacketBrokerName Name of the Network Packet Broker.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The NetworkPacketBroker resource definition.
     */
    public suspend fun getNetworkPacketBroker(
        networkPacketBrokerName: String,
        resourceGroupName: String,
    ): GetNetworkPacketBrokerResult {
        val argument = GetNetworkPacketBrokerPlainArgs(
            networkPacketBrokerName = networkPacketBrokerName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkPacketBrokerResultToKotlin(getNetworkPacketBrokerPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkPacketBroker].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkPacketBrokerPlainArgs].
     * @return The NetworkPacketBroker resource definition.
     */
    public suspend
    fun getNetworkPacketBroker(argument: suspend GetNetworkPacketBrokerPlainArgsBuilder.() -> Unit):
        GetNetworkPacketBrokerResult {
        val builder = GetNetworkPacketBrokerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkPacketBrokerResultToKotlin(getNetworkPacketBrokerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Network Rack resource details.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The NetworkRack resource definition.
     */
    public suspend fun getNetworkRack(argument: GetNetworkRackPlainArgs): GetNetworkRackResult =
        getNetworkRackResultToKotlin(getNetworkRackPlain(argument.toJava()).await())

    /**
     * @see [getNetworkRack].
     * @param networkRackName Name of the Network Rack
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The NetworkRack resource definition.
     */
    public suspend fun getNetworkRack(networkRackName: String, resourceGroupName: String):
        GetNetworkRackResult {
        val argument = GetNetworkRackPlainArgs(
            networkRackName = networkRackName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkRackResultToKotlin(getNetworkRackPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkRack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkRackPlainArgs].
     * @return The NetworkRack resource definition.
     */
    public suspend fun getNetworkRack(argument: suspend GetNetworkRackPlainArgsBuilder.() -> Unit):
        GetNetworkRackResult {
        val builder = GetNetworkRackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkRackResultToKotlin(getNetworkRackPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves details of this Network Tap.
     * Azure REST API version: 2023-06-15.
     * @param argument null
     * @return The Network Tap resource definition.
     */
    public suspend fun getNetworkTap(argument: GetNetworkTapPlainArgs): GetNetworkTapResult =
        getNetworkTapResultToKotlin(getNetworkTapPlain(argument.toJava()).await())

    /**
     * @see [getNetworkTap].
     * @param networkTapName Name of the Network Tap.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Network Tap resource definition.
     */
    public suspend fun getNetworkTap(networkTapName: String, resourceGroupName: String):
        GetNetworkTapResult {
        val argument = GetNetworkTapPlainArgs(
            networkTapName = networkTapName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkTapResultToKotlin(getNetworkTapPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkTap].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkTapPlainArgs].
     * @return The Network Tap resource definition.
     */
    public suspend fun getNetworkTap(argument: suspend GetNetworkTapPlainArgsBuilder.() -> Unit):
        GetNetworkTapResult {
        val builder = GetNetworkTapPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkTapResultToKotlin(getNetworkTapPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Network Tap Rule resource details.
     * Azure REST API version: 2023-06-15.
     * @param argument null
     * @return The NetworkTapRule resource definition.
     */
    public suspend fun getNetworkTapRule(argument: GetNetworkTapRulePlainArgs):
        GetNetworkTapRuleResult =
        getNetworkTapRuleResultToKotlin(getNetworkTapRulePlain(argument.toJava()).await())

    /**
     * @see [getNetworkTapRule].
     * @param networkTapRuleName Name of the Network Tap Rule.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The NetworkTapRule resource definition.
     */
    public suspend fun getNetworkTapRule(networkTapRuleName: String, resourceGroupName: String):
        GetNetworkTapRuleResult {
        val argument = GetNetworkTapRulePlainArgs(
            networkTapRuleName = networkTapRuleName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkTapRuleResultToKotlin(getNetworkTapRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkTapRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkTapRulePlainArgs].
     * @return The NetworkTapRule resource definition.
     */
    public suspend
    fun getNetworkTapRule(argument: suspend GetNetworkTapRulePlainArgsBuilder.() -> Unit):
        GetNetworkTapRuleResult {
        val builder = GetNetworkTapRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkTapRuleResultToKotlin(getNetworkTapRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Implements NetworkToNetworkInterconnects GET method.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The NetworkToNetworkInterconnect resource definition.
     */
    public suspend
    fun getNetworkToNetworkInterconnect(argument: GetNetworkToNetworkInterconnectPlainArgs):
        GetNetworkToNetworkInterconnectResult =
        getNetworkToNetworkInterconnectResultToKotlin(getNetworkToNetworkInterconnectPlain(argument.toJava()).await())

    /**
     * @see [getNetworkToNetworkInterconnect].
     * @param networkFabricName Name of the NetworkFabric.
     * @param networkToNetworkInterconnectName Name of the NetworkToNetworkInterconnect
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The NetworkToNetworkInterconnect resource definition.
     */
    public suspend fun getNetworkToNetworkInterconnect(
        networkFabricName: String,
        networkToNetworkInterconnectName: String,
        resourceGroupName: String,
    ): GetNetworkToNetworkInterconnectResult {
        val argument = GetNetworkToNetworkInterconnectPlainArgs(
            networkFabricName = networkFabricName,
            networkToNetworkInterconnectName = networkToNetworkInterconnectName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkToNetworkInterconnectResultToKotlin(getNetworkToNetworkInterconnectPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkToNetworkInterconnect].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetNetworkToNetworkInterconnectPlainArgs].
     * @return The NetworkToNetworkInterconnect resource definition.
     */
    public suspend
    fun getNetworkToNetworkInterconnect(argument: suspend GetNetworkToNetworkInterconnectPlainArgsBuilder.() -> Unit):
        GetNetworkToNetworkInterconnectResult {
        val builder = GetNetworkToNetworkInterconnectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkToNetworkInterconnectResultToKotlin(getNetworkToNetworkInterconnectPlain(builtArgument.toJava()).await())
    }

    /**
     * Implements Route Policy GET method.
     * Azure REST API version: 2023-02-01-preview.
     * Other available API versions: 2023-06-15.
     * @param argument null
     * @return The RoutePolicy resource definition.
     */
    public suspend fun getRoutePolicy(argument: GetRoutePolicyPlainArgs): GetRoutePolicyResult =
        getRoutePolicyResultToKotlin(getRoutePolicyPlain(argument.toJava()).await())

    /**
     * @see [getRoutePolicy].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param routePolicyName Name of the Route Policy
     * @return The RoutePolicy resource definition.
     */
    public suspend fun getRoutePolicy(resourceGroupName: String, routePolicyName: String):
        GetRoutePolicyResult {
        val argument = GetRoutePolicyPlainArgs(
            resourceGroupName = resourceGroupName,
            routePolicyName = routePolicyName,
        )
        return getRoutePolicyResultToKotlin(getRoutePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoutePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetworkfabric&#46;kotlin&#46;inputs&#46;GetRoutePolicyPlainArgs].
     * @return The RoutePolicy resource definition.
     */
    public suspend fun getRoutePolicy(argument: suspend GetRoutePolicyPlainArgsBuilder.() -> Unit):
        GetRoutePolicyResult {
        val builder = GetRoutePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoutePolicyResultToKotlin(getRoutePolicyPlain(builtArgument.toJava()).await())
    }
}
