@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ManagementNetworkConfigurationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.TerminalServerConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ManagementNetworkConfigurationResponse.Companion.toKotlin as managementNetworkConfigurationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.TerminalServerConfigurationResponse.Companion.toKotlin as terminalServerConfigurationResponseToKotlin

/**
 * Builder for [NetworkFabric].
 */
@PulumiTagMarker
public class NetworkFabricResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkFabricArgs = NetworkFabricArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkFabricArgsBuilder.() -> Unit) {
        val builder = NetworkFabricArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkFabric {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NetworkFabric(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkFabric(builtJavaResource)
    }
}

/**
 * The NetworkFabric resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkFabrics_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFabric = new AzureNative.ManagedNetworkFabric.NetworkFabric("networkFabric", new()
 *     {
 *         Annotation = "annotationValue",
 *         FabricASN = 29249,
 *         Ipv4Prefix = "10.18.0.0/19",
 *         Ipv6Prefix = "3FFE:FFFF:0:CD40::/59",
 *         Location = "eastuseuap",
 *         ManagementNetworkConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.ManagementNetworkConfigurationArgs
 *         {
 *             InfrastructureVpnConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.VpnConfigurationPropertiesArgs
 *             {
 *                 OptionAProperties = new AzureNative.ManagedNetworkFabric.Inputs.OptionAPropertiesArgs
 *                 {
 *                     Mtu = 5892,
 *                     PeerASN = 42666,
 *                     PrimaryIpv4Prefix = "20.0.0.12/30",
 *                     PrimaryIpv6Prefix = "3FFE:FFFF:0:CD30::a8/126",
 *                     SecondaryIpv4Prefix = "20.0.0.13/30",
 *                     SecondaryIpv6Prefix = "3FFE:FFFF:0:CD30::ac/126",
 *                     VlanId = 2724,
 *                 },
 *                 OptionBProperties = new AzureNative.ManagedNetworkFabric.Inputs.FabricOptionBPropertiesArgs
 *                 {
 *                     ExportRouteTargets = new[]
 *                     {
 *                         "65046:10039",
 *                     },
 *                     ImportRouteTargets = new[]
 *                     {
 *                         "65046:10039",
 *                     },
 *                 },
 *                 PeeringOption = "OptionA",
 *             },
 *             WorkloadVpnConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.VpnConfigurationPropertiesArgs
 *             {
 *                 OptionAProperties = new AzureNative.ManagedNetworkFabric.Inputs.OptionAPropertiesArgs
 *                 {
 *                     Mtu = 5892,
 *                     PeerASN = 42666,
 *                     PrimaryIpv4Prefix = "10.0.0.14/30",
 *                     PrimaryIpv6Prefix = "2FFE:FFFF:0:CD30::a7/126",
 *                     SecondaryIpv4Prefix = "10.0.0.15/30",
 *                     SecondaryIpv6Prefix = "2FFE:FFFF:0:CD30::ac/126",
 *                     VlanId = 2724,
 *                 },
 *                 OptionBProperties = new AzureNative.ManagedNetworkFabric.Inputs.FabricOptionBPropertiesArgs
 *                 {
 *                     ExportRouteTargets = new[]
 *                     {
 *                         "65046:10050",
 *                     },
 *                     ImportRouteTargets = new[]
 *                     {
 *                         "65046:10050",
 *                     },
 *                 },
 *                 PeeringOption = "OptionA",
 *             },
 *         },
 *         NetworkFabricControllerId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName",
 *         NetworkFabricName = "FabricName",
 *         NetworkFabricSku = "M4-A400-A100-C16-aa",
 *         RackCount = 4,
 *         ResourceGroupName = "resourceGroupName",
 *         ServerCountPerRack = 8,
 *         Tags =
 *         {
 *             { "key6468", "" },
 *         },
 *         TerminalServerConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.TerminalServerConfigurationArgs
 *         {
 *             Password = "xxxx",
 *             PrimaryIpv4Prefix = "20.0.0.12/30",
 *             PrimaryIpv6Prefix = "3FFE:FFFF:0:CD30::a8/126",
 *             SecondaryIpv4Prefix = "20.0.0.13/30",
 *             SecondaryIpv6Prefix = "3FFE:FFFF:0:CD30::ac/126",
 *             SerialNumber = "123456",
 *             Username = "username",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := managednetworkfabric.NewNetworkFabric(ctx, "networkFabric", &managednetworkfabric.NetworkFabricArgs{
 * Annotation: pulumi.String("annotationValue"),
 * FabricASN: pulumi.Int(29249),
 * Ipv4Prefix: pulumi.String("10.18.0.0/19"),
 * Ipv6Prefix: pulumi.String("3FFE:FFFF:0:CD40::/59"),
 * Location: pulumi.String("eastuseuap"),
 * ManagementNetworkConfiguration: managednetworkfabric.ManagementNetworkConfigurationResponse{
 * InfrastructureVpnConfiguration: interface{}{
 * OptionAProperties: &managednetworkfabric.OptionAPropertiesArgs{
 * Mtu: pulumi.Int(5892),
 * PeerASN: pulumi.Int(42666),
 * PrimaryIpv4Prefix: pulumi.String("20.0.0.12/30"),
 * PrimaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::a8/126"),
 * SecondaryIpv4Prefix: pulumi.String("20.0.0.13/30"),
 * SecondaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::ac/126"),
 * VlanId: pulumi.Int(2724),
 * },
 * OptionBProperties: &managednetworkfabric.FabricOptionBPropertiesArgs{
 * ExportRouteTargets: pulumi.StringArray{
 * pulumi.String("65046:10039"),
 * },
 * ImportRouteTargets: pulumi.StringArray{
 * pulumi.String("65046:10039"),
 * },
 * },
 * PeeringOption: pulumi.String("OptionA"),
 * },
 * WorkloadVpnConfiguration: interface{}{
 * OptionAProperties: &managednetworkfabric.OptionAPropertiesArgs{
 * Mtu: pulumi.Int(5892),
 * PeerASN: pulumi.Int(42666),
 * PrimaryIpv4Prefix: pulumi.String("10.0.0.14/30"),
 * PrimaryIpv6Prefix: pulumi.String("2FFE:FFFF:0:CD30::a7/126"),
 * SecondaryIpv4Prefix: pulumi.String("10.0.0.15/30"),
 * SecondaryIpv6Prefix: pulumi.String("2FFE:FFFF:0:CD30::ac/126"),
 * VlanId: pulumi.Int(2724),
 * },
 * OptionBProperties: &managednetworkfabric.FabricOptionBPropertiesArgs{
 * ExportRouteTargets: pulumi.StringArray{
 * pulumi.String("65046:10050"),
 * },
 * ImportRouteTargets: pulumi.StringArray{
 * pulumi.String("65046:10050"),
 * },
 * },
 * PeeringOption: pulumi.String("OptionA"),
 * },
 * },
 * NetworkFabricControllerId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName"),
 * NetworkFabricName: pulumi.String("FabricName"),
 * NetworkFabricSku: pulumi.String("M4-A400-A100-C16-aa"),
 * RackCount: pulumi.Int(4),
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * ServerCountPerRack: pulumi.Int(8),
 * Tags: pulumi.StringMap{
 * "key6468": pulumi.String(""),
 * },
 * TerminalServerConfiguration: &managednetworkfabric.TerminalServerConfigurationArgs{
 * Password: pulumi.String("xxxx"),
 * PrimaryIpv4Prefix: pulumi.String("20.0.0.12/30"),
 * PrimaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::a8/126"),
 * SecondaryIpv4Prefix: pulumi.String("20.0.0.13/30"),
 * SecondaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::ac/126"),
 * SerialNumber: pulumi.String("123456"),
 * Username: pulumi.String("username"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkFabric;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkFabricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFabric = new NetworkFabric("networkFabric", NetworkFabricArgs.builder()
 *             .annotation("annotationValue")
 *             .fabricASN(29249)
 *             .ipv4Prefix("10.18.0.0/19")
 *             .ipv6Prefix("3FFE:FFFF:0:CD40::/59")
 *             .location("eastuseuap")
 *             .managementNetworkConfiguration(Map.ofEntries(
 *                 Map.entry("infrastructureVpnConfiguration", Map.ofEntries(
 *                     Map.entry("optionAProperties", Map.ofEntries(
 *                         Map.entry("mtu", 5892),
 *                         Map.entry("peerASN", 42666),
 *                         Map.entry("primaryIpv4Prefix", "20.0.0.12/30"),
 *                         Map.entry("primaryIpv6Prefix", "3FFE:FFFF:0:CD30::a8/126"),
 *                         Map.entry("secondaryIpv4Prefix", "20.0.0.13/30"),
 *                         Map.entry("secondaryIpv6Prefix", "3FFE:FFFF:0:CD30::ac/126"),
 *                         Map.entry("vlanId", 2724)
 *                     )),
 *                     Map.entry("optionBProperties", Map.ofEntries(
 *                         Map.entry("exportRouteTargets", "65046:10039"),
 *                         Map.entry("importRouteTargets", "65046:10039")
 *                     )),
 *                     Map.entry("peeringOption", "OptionA")
 *                 )),
 *                 Map.entry("workloadVpnConfiguration", Map.ofEntries(
 *                     Map.entry("optionAProperties", Map.ofEntries(
 *                         Map.entry("mtu", 5892),
 *                         Map.entry("peerASN", 42666),
 *                         Map.entry("primaryIpv4Prefix", "10.0.0.14/30"),
 *                         Map.entry("primaryIpv6Prefix", "2FFE:FFFF:0:CD30::a7/126"),
 *                         Map.entry("secondaryIpv4Prefix", "10.0.0.15/30"),
 *                         Map.entry("secondaryIpv6Prefix", "2FFE:FFFF:0:CD30::ac/126"),
 *                         Map.entry("vlanId", 2724)
 *                     )),
 *                     Map.entry("optionBProperties", Map.ofEntries(
 *                         Map.entry("exportRouteTargets", "65046:10050"),
 *                         Map.entry("importRouteTargets", "65046:10050")
 *                     )),
 *                     Map.entry("peeringOption", "OptionA")
 *                 ))
 *             ))
 *             .networkFabricControllerId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName")
 *             .networkFabricName("FabricName")
 *             .networkFabricSku("M4-A400-A100-C16-aa")
 *             .rackCount(4)
 *             .resourceGroupName("resourceGroupName")
 *             .serverCountPerRack(8)
 *             .tags(Map.of("key6468", ""))
 *             .terminalServerConfiguration(Map.ofEntries(
 *                 Map.entry("password", "xxxx"),
 *                 Map.entry("primaryIpv4Prefix", "20.0.0.12/30"),
 *                 Map.entry("primaryIpv6Prefix", "3FFE:FFFF:0:CD30::a8/126"),
 *                 Map.entry("secondaryIpv4Prefix", "20.0.0.13/30"),
 *                 Map.entry("secondaryIpv6Prefix", "3FFE:FFFF:0:CD30::ac/126"),
 *                 Map.entry("serialNumber", "123456"),
 *                 Map.entry("username", "username")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkFabric FabricName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}
 * ```
 */
public class NetworkFabric internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NetworkFabric,
) : KotlinCustomResource(javaResource, NetworkFabricMapper) {
    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ASN of CE devices for CE/PE connectivity.
     */
    public val fabricASN: Output<Int>
        get() = javaResource.fabricASN().applyValue({ args0 -> args0 })

    /**
     * IPv4Prefix for Management Network. Example: 10.1.0.0/19.
     */
    public val ipv4Prefix: Output<String>?
        get() = javaResource.ipv4Prefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
     */
    public val ipv6Prefix: Output<String>?
        get() = javaResource.ipv6Prefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of L2IsolationDomain resource IDs under the Network Fabric.
     */
    public val l2IsolationDomains: Output<List<String>>
        get() = javaResource.l2IsolationDomains().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of L3IsolationDomain resource IDs under the Network Fabric.
     */
    public val l3IsolationDomains: Output<List<String>>
        get() = javaResource.l3IsolationDomains().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Configuration to be used to setup the management network.
     */
    public val managementNetworkConfiguration: Output<ManagementNetworkConfigurationResponse>
        get() = javaResource.managementNetworkConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                managementNetworkConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure resource ID for the NetworkFabricController the NetworkFabric belongs.
     */
    public val networkFabricControllerId: Output<String>
        get() = javaResource.networkFabricControllerId().applyValue({ args0 -> args0 })

    /**
     * Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The SKU determines whether it is a single / multi rack Network Fabric.
     */
    public val networkFabricSku: Output<String>
        get() = javaResource.networkFabricSku().applyValue({ args0 -> args0 })

    /**
     * Gets the operational state of the resource.
     */
    public val operationalState: Output<String>
        get() = javaResource.operationalState().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Number of racks associated to Network Fabric.Possible values are from 2-8.
     */
    public val rackCount: Output<Int>
        get() = javaResource.rackCount().applyValue({ args0 -> args0 })

    /**
     * List of NetworkRack resource IDs under the Network Fabric. The number of racks allowed depends on the Network Fabric SKU.
     */
    public val racks: Output<List<String>>
        get() = javaResource.racks().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Router Id of CE to be used for MP-BGP between PE and CE
     */
    public val routerId: Output<String>
        get() = javaResource.routerId().applyValue({ args0 -> args0 })

    /**
     * Number of servers.Possible values are from 1-16.
     */
    public val serverCountPerRack: Output<Int>
        get() = javaResource.serverCountPerRack().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Network and credentials configuration currently applied to terminal server.
     */
    public val terminalServerConfiguration: Output<TerminalServerConfigurationResponse>
        get() = javaResource.terminalServerConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                terminalServerConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkFabricMapper : ResourceMapper<NetworkFabric> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NetworkFabric::class == javaResource::class

    override fun map(javaResource: Resource): NetworkFabric = NetworkFabric(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.NetworkFabric,
    )
}

/**
 * @see [NetworkFabric].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkFabric].
 */
public suspend fun networkFabric(
    name: String,
    block: suspend NetworkFabricResourceBuilder.() -> Unit,
): NetworkFabric {
    val builder = NetworkFabricResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkFabric].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkFabric(name: String): NetworkFabric {
    val builder = NetworkFabricResourceBuilder()
    builder.name(name)
    return builder.build()
}
