@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NetworkFabricArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ManagementNetworkConfigurationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ManagementNetworkConfigurationArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.TerminalServerConfigurationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.TerminalServerConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The NetworkFabric resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkFabrics_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFabric = new AzureNative.ManagedNetworkFabric.NetworkFabric("networkFabric", new()
 *     {
 *         Annotation = "annotationValue",
 *         FabricASN = 29249,
 *         Ipv4Prefix = "10.18.0.0/19",
 *         Ipv6Prefix = "3FFE:FFFF:0:CD40::/59",
 *         Location = "eastuseuap",
 *         ManagementNetworkConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.ManagementNetworkConfigurationArgs
 *         {
 *             InfrastructureVpnConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.VpnConfigurationPropertiesArgs
 *             {
 *                 OptionAProperties = new AzureNative.ManagedNetworkFabric.Inputs.OptionAPropertiesArgs
 *                 {
 *                     Mtu = 5892,
 *                     PeerASN = 42666,
 *                     PrimaryIpv4Prefix = "20.0.0.12/30",
 *                     PrimaryIpv6Prefix = "3FFE:FFFF:0:CD30::a8/126",
 *                     SecondaryIpv4Prefix = "20.0.0.13/30",
 *                     SecondaryIpv6Prefix = "3FFE:FFFF:0:CD30::ac/126",
 *                     VlanId = 2724,
 *                 },
 *                 OptionBProperties = new AzureNative.ManagedNetworkFabric.Inputs.FabricOptionBPropertiesArgs
 *                 {
 *                     ExportRouteTargets = new[]
 *                     {
 *                         "65046:10039",
 *                     },
 *                     ImportRouteTargets = new[]
 *                     {
 *                         "65046:10039",
 *                     },
 *                 },
 *                 PeeringOption = "OptionA",
 *             },
 *             WorkloadVpnConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.VpnConfigurationPropertiesArgs
 *             {
 *                 OptionAProperties = new AzureNative.ManagedNetworkFabric.Inputs.OptionAPropertiesArgs
 *                 {
 *                     Mtu = 5892,
 *                     PeerASN = 42666,
 *                     PrimaryIpv4Prefix = "10.0.0.14/30",
 *                     PrimaryIpv6Prefix = "2FFE:FFFF:0:CD30::a7/126",
 *                     SecondaryIpv4Prefix = "10.0.0.15/30",
 *                     SecondaryIpv6Prefix = "2FFE:FFFF:0:CD30::ac/126",
 *                     VlanId = 2724,
 *                 },
 *                 OptionBProperties = new AzureNative.ManagedNetworkFabric.Inputs.FabricOptionBPropertiesArgs
 *                 {
 *                     ExportRouteTargets = new[]
 *                     {
 *                         "65046:10050",
 *                     },
 *                     ImportRouteTargets = new[]
 *                     {
 *                         "65046:10050",
 *                     },
 *                 },
 *                 PeeringOption = "OptionA",
 *             },
 *         },
 *         NetworkFabricControllerId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName",
 *         NetworkFabricName = "FabricName",
 *         NetworkFabricSku = "M4-A400-A100-C16-aa",
 *         RackCount = 4,
 *         ResourceGroupName = "resourceGroupName",
 *         ServerCountPerRack = 8,
 *         Tags =
 *         {
 *             { "key6468", "" },
 *         },
 *         TerminalServerConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.TerminalServerConfigurationArgs
 *         {
 *             Password = "xxxx",
 *             PrimaryIpv4Prefix = "20.0.0.12/30",
 *             PrimaryIpv6Prefix = "3FFE:FFFF:0:CD30::a8/126",
 *             SecondaryIpv4Prefix = "20.0.0.13/30",
 *             SecondaryIpv6Prefix = "3FFE:FFFF:0:CD30::ac/126",
 *             SerialNumber = "123456",
 *             Username = "username",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := managednetworkfabric.NewNetworkFabric(ctx, "networkFabric", &managednetworkfabric.NetworkFabricArgs{
 * Annotation: pulumi.String("annotationValue"),
 * FabricASN: pulumi.Int(29249),
 * Ipv4Prefix: pulumi.String("10.18.0.0/19"),
 * Ipv6Prefix: pulumi.String("3FFE:FFFF:0:CD40::/59"),
 * Location: pulumi.String("eastuseuap"),
 * ManagementNetworkConfiguration: managednetworkfabric.ManagementNetworkConfigurationResponse{
 * InfrastructureVpnConfiguration: interface{}{
 * OptionAProperties: &managednetworkfabric.OptionAPropertiesArgs{
 * Mtu: pulumi.Int(5892),
 * PeerASN: pulumi.Int(42666),
 * PrimaryIpv4Prefix: pulumi.String("20.0.0.12/30"),
 * PrimaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::a8/126"),
 * SecondaryIpv4Prefix: pulumi.String("20.0.0.13/30"),
 * SecondaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::ac/126"),
 * VlanId: pulumi.Int(2724),
 * },
 * OptionBProperties: &managednetworkfabric.FabricOptionBPropertiesArgs{
 * ExportRouteTargets: pulumi.StringArray{
 * pulumi.String("65046:10039"),
 * },
 * ImportRouteTargets: pulumi.StringArray{
 * pulumi.String("65046:10039"),
 * },
 * },
 * PeeringOption: pulumi.String("OptionA"),
 * },
 * WorkloadVpnConfiguration: interface{}{
 * OptionAProperties: &managednetworkfabric.OptionAPropertiesArgs{
 * Mtu: pulumi.Int(5892),
 * PeerASN: pulumi.Int(42666),
 * PrimaryIpv4Prefix: pulumi.String("10.0.0.14/30"),
 * PrimaryIpv6Prefix: pulumi.String("2FFE:FFFF:0:CD30::a7/126"),
 * SecondaryIpv4Prefix: pulumi.String("10.0.0.15/30"),
 * SecondaryIpv6Prefix: pulumi.String("2FFE:FFFF:0:CD30::ac/126"),
 * VlanId: pulumi.Int(2724),
 * },
 * OptionBProperties: &managednetworkfabric.FabricOptionBPropertiesArgs{
 * ExportRouteTargets: pulumi.StringArray{
 * pulumi.String("65046:10050"),
 * },
 * ImportRouteTargets: pulumi.StringArray{
 * pulumi.String("65046:10050"),
 * },
 * },
 * PeeringOption: pulumi.String("OptionA"),
 * },
 * },
 * NetworkFabricControllerId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName"),
 * NetworkFabricName: pulumi.String("FabricName"),
 * NetworkFabricSku: pulumi.String("M4-A400-A100-C16-aa"),
 * RackCount: pulumi.Int(4),
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * ServerCountPerRack: pulumi.Int(8),
 * Tags: pulumi.StringMap{
 * "key6468": pulumi.String(""),
 * },
 * TerminalServerConfiguration: &managednetworkfabric.TerminalServerConfigurationArgs{
 * Password: pulumi.String("xxxx"),
 * PrimaryIpv4Prefix: pulumi.String("20.0.0.12/30"),
 * PrimaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::a8/126"),
 * SecondaryIpv4Prefix: pulumi.String("20.0.0.13/30"),
 * SecondaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::ac/126"),
 * SerialNumber: pulumi.String("123456"),
 * Username: pulumi.String("username"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkFabric;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkFabricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFabric = new NetworkFabric("networkFabric", NetworkFabricArgs.builder()
 *             .annotation("annotationValue")
 *             .fabricASN(29249)
 *             .ipv4Prefix("10.18.0.0/19")
 *             .ipv6Prefix("3FFE:FFFF:0:CD40::/59")
 *             .location("eastuseuap")
 *             .managementNetworkConfiguration(Map.ofEntries(
 *                 Map.entry("infrastructureVpnConfiguration", Map.ofEntries(
 *                     Map.entry("optionAProperties", Map.ofEntries(
 *                         Map.entry("mtu", 5892),
 *                         Map.entry("peerASN", 42666),
 *                         Map.entry("primaryIpv4Prefix", "20.0.0.12/30"),
 *                         Map.entry("primaryIpv6Prefix", "3FFE:FFFF:0:CD30::a8/126"),
 *                         Map.entry("secondaryIpv4Prefix", "20.0.0.13/30"),
 *                         Map.entry("secondaryIpv6Prefix", "3FFE:FFFF:0:CD30::ac/126"),
 *                         Map.entry("vlanId", 2724)
 *                     )),
 *                     Map.entry("optionBProperties", Map.ofEntries(
 *                         Map.entry("exportRouteTargets", "65046:10039"),
 *                         Map.entry("importRouteTargets", "65046:10039")
 *                     )),
 *                     Map.entry("peeringOption", "OptionA")
 *                 )),
 *                 Map.entry("workloadVpnConfiguration", Map.ofEntries(
 *                     Map.entry("optionAProperties", Map.ofEntries(
 *                         Map.entry("mtu", 5892),
 *                         Map.entry("peerASN", 42666),
 *                         Map.entry("primaryIpv4Prefix", "10.0.0.14/30"),
 *                         Map.entry("primaryIpv6Prefix", "2FFE:FFFF:0:CD30::a7/126"),
 *                         Map.entry("secondaryIpv4Prefix", "10.0.0.15/30"),
 *                         Map.entry("secondaryIpv6Prefix", "2FFE:FFFF:0:CD30::ac/126"),
 *                         Map.entry("vlanId", 2724)
 *                     )),
 *                     Map.entry("optionBProperties", Map.ofEntries(
 *                         Map.entry("exportRouteTargets", "65046:10050"),
 *                         Map.entry("importRouteTargets", "65046:10050")
 *                     )),
 *                     Map.entry("peeringOption", "OptionA")
 *                 ))
 *             ))
 *             .networkFabricControllerId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName")
 *             .networkFabricName("FabricName")
 *             .networkFabricSku("M4-A400-A100-C16-aa")
 *             .rackCount(4)
 *             .resourceGroupName("resourceGroupName")
 *             .serverCountPerRack(8)
 *             .tags(Map.of("key6468", ""))
 *             .terminalServerConfiguration(Map.ofEntries(
 *                 Map.entry("password", "xxxx"),
 *                 Map.entry("primaryIpv4Prefix", "20.0.0.12/30"),
 *                 Map.entry("primaryIpv6Prefix", "3FFE:FFFF:0:CD30::a8/126"),
 *                 Map.entry("secondaryIpv4Prefix", "20.0.0.13/30"),
 *                 Map.entry("secondaryIpv6Prefix", "3FFE:FFFF:0:CD30::ac/126"),
 *                 Map.entry("serialNumber", "123456"),
 *                 Map.entry("username", "username")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkFabric FabricName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}
 * ```
 * @property annotation Switch configuration description.
 * @property fabricASN ASN of CE devices for CE/PE connectivity.
 * @property ipv4Prefix IPv4Prefix for Management Network. Example: 10.1.0.0/19.
 * @property ipv6Prefix IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
 * @property location The geo-location where the resource lives
 * @property managementNetworkConfiguration Configuration to be used to setup the management network.
 * @property networkFabricControllerId Azure resource ID for the NetworkFabricController the NetworkFabric belongs.
 * @property networkFabricName Name of the Network Fabric
 * @property networkFabricSku Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The SKU determines whether it is a single / multi rack Network Fabric.
 * @property rackCount Number of racks associated to Network Fabric.Possible values are from 2-8.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverCountPerRack Number of servers.Possible values are from 1-16.
 * @property tags Resource tags.
 * @property terminalServerConfiguration Network and credentials configuration currently applied to terminal server.
 */
public data class NetworkFabricArgs(
    public val `annotation`: Output<String>? = null,
    public val fabricASN: Output<Int>? = null,
    public val ipv4Prefix: Output<String>? = null,
    public val ipv6Prefix: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managementNetworkConfiguration: Output<ManagementNetworkConfigurationArgs>? = null,
    public val networkFabricControllerId: Output<String>? = null,
    public val networkFabricName: Output<String>? = null,
    public val networkFabricSku: Output<String>? = null,
    public val rackCount: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverCountPerRack: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val terminalServerConfiguration: Output<TerminalServerConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NetworkFabricArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.NetworkFabricArgs =
        com.pulumi.azurenative.managednetworkfabric.NetworkFabricArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .fabricASN(fabricASN?.applyValue({ args0 -> args0 }))
            .ipv4Prefix(ipv4Prefix?.applyValue({ args0 -> args0 }))
            .ipv6Prefix(ipv6Prefix?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managementNetworkConfiguration(
                managementNetworkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .networkFabricControllerId(networkFabricControllerId?.applyValue({ args0 -> args0 }))
            .networkFabricName(networkFabricName?.applyValue({ args0 -> args0 }))
            .networkFabricSku(networkFabricSku?.applyValue({ args0 -> args0 }))
            .rackCount(rackCount?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverCountPerRack(serverCountPerRack?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .terminalServerConfiguration(
                terminalServerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkFabricArgs].
 */
@PulumiTagMarker
public class NetworkFabricArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var fabricASN: Output<Int>? = null

    private var ipv4Prefix: Output<String>? = null

    private var ipv6Prefix: Output<String>? = null

    private var location: Output<String>? = null

    private var managementNetworkConfiguration: Output<ManagementNetworkConfigurationArgs>? = null

    private var networkFabricControllerId: Output<String>? = null

    private var networkFabricName: Output<String>? = null

    private var networkFabricSku: Output<String>? = null

    private var rackCount: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverCountPerRack: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var terminalServerConfiguration: Output<TerminalServerConfigurationArgs>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("nbuawxqbexmnwhpx")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value ASN of CE devices for CE/PE connectivity.
     */
    @JvmName("nadlxtyftkopkitn")
    public suspend fun fabricASN(`value`: Output<Int>) {
        this.fabricASN = value
    }

    /**
     * @param value IPv4Prefix for Management Network. Example: 10.1.0.0/19.
     */
    @JvmName("tqfskisbilyicijg")
    public suspend fun ipv4Prefix(`value`: Output<String>) {
        this.ipv4Prefix = value
    }

    /**
     * @param value IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
     */
    @JvmName("uowxriulhsihbxlv")
    public suspend fun ipv6Prefix(`value`: Output<String>) {
        this.ipv6Prefix = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jqpcgcwfgqohwxtp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Configuration to be used to setup the management network.
     */
    @JvmName("ysmwlbxbbawjahge")
    public suspend
    fun managementNetworkConfiguration(`value`: Output<ManagementNetworkConfigurationArgs>) {
        this.managementNetworkConfiguration = value
    }

    /**
     * @param value Azure resource ID for the NetworkFabricController the NetworkFabric belongs.
     */
    @JvmName("fuykprcncmbqqcqk")
    public suspend fun networkFabricControllerId(`value`: Output<String>) {
        this.networkFabricControllerId = value
    }

    /**
     * @param value Name of the Network Fabric
     */
    @JvmName("xxhhsuucapmpqqod")
    public suspend fun networkFabricName(`value`: Output<String>) {
        this.networkFabricName = value
    }

    /**
     * @param value Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The SKU determines whether it is a single / multi rack Network Fabric.
     */
    @JvmName("tlbcgsgivmfjhfdm")
    public suspend fun networkFabricSku(`value`: Output<String>) {
        this.networkFabricSku = value
    }

    /**
     * @param value Number of racks associated to Network Fabric.Possible values are from 2-8.
     */
    @JvmName("gwekqsskijnbfykf")
    public suspend fun rackCount(`value`: Output<Int>) {
        this.rackCount = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fenncvbehoxrdtum")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Number of servers.Possible values are from 1-16.
     */
    @JvmName("qmuxcdjnddakdihv")
    public suspend fun serverCountPerRack(`value`: Output<Int>) {
        this.serverCountPerRack = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ttsffkmlvmkxthgl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Network and credentials configuration currently applied to terminal server.
     */
    @JvmName("wgsywnyfalelsudv")
    public suspend fun terminalServerConfiguration(`value`: Output<TerminalServerConfigurationArgs>) {
        this.terminalServerConfiguration = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("lgxlsxcdreskjgwg")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value ASN of CE devices for CE/PE connectivity.
     */
    @JvmName("fsmgohyqqdovusqt")
    public suspend fun fabricASN(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricASN = mapped
    }

    /**
     * @param value IPv4Prefix for Management Network. Example: 10.1.0.0/19.
     */
    @JvmName("wamxrsfanuodwebx")
    public suspend fun ipv4Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Prefix = mapped
    }

    /**
     * @param value IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
     */
    @JvmName("pnuouvaqkuvoluqj")
    public suspend fun ipv6Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Prefix = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("urtjpognufjsgkli")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Configuration to be used to setup the management network.
     */
    @JvmName("kmuodhjwvbbbaqsf")
    public suspend fun managementNetworkConfiguration(`value`: ManagementNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementNetworkConfiguration = mapped
    }

    /**
     * @param argument Configuration to be used to setup the management network.
     */
    @JvmName("ejlhsmyiuqoydsva")
    public suspend
    fun managementNetworkConfiguration(argument: suspend ManagementNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managementNetworkConfiguration = mapped
    }

    /**
     * @param value Azure resource ID for the NetworkFabricController the NetworkFabric belongs.
     */
    @JvmName("kkyugtbxiudkptwg")
    public suspend fun networkFabricControllerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricControllerId = mapped
    }

    /**
     * @param value Name of the Network Fabric
     */
    @JvmName("ioixvxdxdxgohuyw")
    public suspend fun networkFabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricName = mapped
    }

    /**
     * @param value Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The SKU determines whether it is a single / multi rack Network Fabric.
     */
    @JvmName("qultcakfspjsrnqf")
    public suspend fun networkFabricSku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricSku = mapped
    }

    /**
     * @param value Number of racks associated to Network Fabric.Possible values are from 2-8.
     */
    @JvmName("sxopubcgeacsdrkw")
    public suspend fun rackCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackCount = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ubbciwmmslgbwtqh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Number of servers.Possible values are from 1-16.
     */
    @JvmName("xdpblimqklgorohw")
    public suspend fun serverCountPerRack(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCountPerRack = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yudllbjkmtfkevxa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("uxnljrmjiiqnaeep")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Network and credentials configuration currently applied to terminal server.
     */
    @JvmName("ijtjmpuwhvhlxmnv")
    public suspend fun terminalServerConfiguration(`value`: TerminalServerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminalServerConfiguration = mapped
    }

    /**
     * @param argument Network and credentials configuration currently applied to terminal server.
     */
    @JvmName("xpfskjkmteormeye")
    public suspend
    fun terminalServerConfiguration(argument: suspend TerminalServerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TerminalServerConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.terminalServerConfiguration = mapped
    }

    internal fun build(): NetworkFabricArgs = NetworkFabricArgs(
        `annotation` = `annotation`,
        fabricASN = fabricASN,
        ipv4Prefix = ipv4Prefix,
        ipv6Prefix = ipv6Prefix,
        location = location,
        managementNetworkConfiguration = managementNetworkConfiguration,
        networkFabricControllerId = networkFabricControllerId,
        networkFabricName = networkFabricName,
        networkFabricSku = networkFabricSku,
        rackCount = rackCount,
        resourceGroupName = resourceGroupName,
        serverCountPerRack = serverCountPerRack,
        tags = tags,
        terminalServerConfiguration = terminalServerConfiguration,
    )
}
